/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.api.module.ModuleInfoBuilder;
import org.artifactory.api.module.regex.NamedMatcher;
import org.artifactory.api.module.regex.NamedPattern;
import org.artifactory.descriptor.repo.RepoLayout;
import org.artifactory.util.RepoLayoutUtils;
import org.artifactory.util.layouts.token.BaseTokenFilter;
import org.jfrog.client.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModuleInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(ModuleInfoUtils.class);

    private ModuleInfoUtils() {
    }

    public static String constructArtifactPath(ModuleInfo moduleInfo, RepoLayout repoLayout) {
        return ModuleInfoUtils.constructArtifactPath(moduleInfo, repoLayout, true);
    }

    public static String constructArtifactPath(ModuleInfo moduleInfo, RepoLayout repoLayout, boolean clearUnReplacedOptionals) {
        return ModuleInfoUtils.constructItemPath(moduleInfo, repoLayout, false, clearUnReplacedOptionals);
    }

    public static String constructDescriptorPath(ModuleInfo moduleInfo, RepoLayout repoLayout, boolean clearUnReplacedOptionals) {
        return ModuleInfoUtils.constructItemPath(moduleInfo, repoLayout, true, clearUnReplacedOptionals);
    }

    public static ModuleInfo moduleInfoFromArtifactPath(String itemPath, RepoLayout repoLayout) {
        return ModuleInfoUtils.moduleInfoFromItemPath(itemPath, repoLayout, false, false);
    }

    public static ModuleInfo moduleInfoFromArtifactPath(String itemPath, RepoLayout repoLayout, boolean supportVersionsTokens) {
        ModuleInfo moduleInfo = null;
        if (repoLayout.isDistinctiveDescriptorPathPattern() && (moduleInfo = ModuleInfoUtils.moduleInfoFromItemPath(itemPath, repoLayout, true, supportVersionsTokens)).isValid() && StringUtils.isBlank((String)moduleInfo.getExt())) {
            moduleInfo = new ModuleInfoBuilder(moduleInfo).ext(PathUtils.getExtension((String)itemPath)).build();
        }
        if (moduleInfo == null || !moduleInfo.isValid()) {
            moduleInfo = ModuleInfoUtils.moduleInfoFromItemPath(itemPath, repoLayout, false, supportVersionsTokens);
        }
        return moduleInfo;
    }

    public static ModuleInfo moduleInfoFromDescriptorPath(String itemPath, RepoLayout repoLayout) {
        ModuleInfo moduleInfo = ModuleInfoUtils.moduleInfoFromItemPath(itemPath, repoLayout, true, false);
        if (repoLayout.isDistinctiveDescriptorPathPattern() && moduleInfo.isValid() && StringUtils.isBlank((String)moduleInfo.getExt())) {
            return new ModuleInfoBuilder(moduleInfo).ext(PathUtils.getExtension((String)itemPath)).build();
        }
        return moduleInfo;
    }

    private static String constructItemPath(ModuleInfo moduleInfo, RepoLayout repoLayout, boolean descriptor, boolean clearUnReplacedOptionals) {
        if (moduleInfo == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null module info object.");
        }
        if (!moduleInfo.isValid()) {
            throw new IllegalArgumentException("Unable to construct a path from an invalid module info object.");
        }
        if (repoLayout == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null repository layout.");
        }
        String itemPathPattern = descriptor && repoLayout.isDistinctiveDescriptorPathPattern() ? repoLayout.getDescriptorPathPattern() : repoLayout.getArtifactPathPattern();
        itemPathPattern = ModuleInfoUtils.replaceDeclaredFields(moduleInfo, itemPathPattern);
        itemPathPattern = RepoLayoutUtils.removeReplacedTokenOptionalBrackets((String)itemPathPattern, (boolean)false);
        if (clearUnReplacedOptionals) {
            itemPathPattern = RepoLayoutUtils.removeUnReplacedTokenOptionalBrackets((String)itemPathPattern);
        }
        return itemPathPattern;
    }

    public static String constructBaseItemPath(ModuleInfo moduleInfo, RepoLayout repoLayout) {
        if (moduleInfo == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null module info object.");
        }
        if (repoLayout == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null repository layout.");
        }
        String itemPathPattern = repoLayout.getArtifactPathPattern();
        itemPathPattern = ModuleInfoUtils.replaceDeclaredFields(moduleInfo, itemPathPattern);
        itemPathPattern = RepoLayoutUtils.removeUnReplacedTokenOptionalBrackets((String)itemPathPattern);
        if (StringUtils.isBlank((String)(itemPathPattern = ModuleInfoUtils.verifyAndBuildPathPattern(itemPathPattern)))) {
            log.warn("The repo layout '{}' is invalid and cannot be parsed for searching versions.", (Object)repoLayout.getName());
        }
        return itemPathPattern;
    }

    public static String constructModuleVersion(ModuleInfo moduleInfo, RepoLayout repoLayout) {
        if (moduleInfo == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null module info object.");
        }
        if (repoLayout == null) {
            throw new IllegalArgumentException("Unable to construct a path from a null repository layout.");
        }
        String itemPathPattern = repoLayout.getArtifactPathPattern();
        if (!StringUtils.isBlank((String)(itemPathPattern = ModuleInfoUtils.getModuleVersionPattern(itemPathPattern)))) {
            itemPathPattern = ModuleInfoUtils.replaceDeclaredFields(moduleInfo, itemPathPattern);
            itemPathPattern = RepoLayoutUtils.removeReplacedTokenOptionalBrackets((String)itemPathPattern, (boolean)false);
            itemPathPattern = RepoLayoutUtils.removeUnReplacedTokenOptionalBrackets((String)itemPathPattern);
        } else {
            log.warn("The repo layout '{}' is invalid and cannot be parsed for version file name", (Object)repoLayout.getName());
        }
        return itemPathPattern;
    }

    private static String getModuleVersionPattern(String itemPathPattern) {
        String wrappedBaseRevisionToken = RepoLayoutUtils.wrapKeywordAsToken((String)"baseRev");
        String wrappedFileItegRevToken = RepoLayoutUtils.wrapKeywordAsToken((String)"fileItegRev");
        int baseRevStartPos = StringUtils.lastIndexOf((String)itemPathPattern, (String)wrappedBaseRevisionToken);
        int fileItegRevEndPos = StringUtils.lastIndexOf((String)itemPathPattern, (String)wrappedFileItegRevToken);
        int indexOfClosingOptionalBracket = StringUtils.indexOf((String)itemPathPattern, (String)")", (int)fileItegRevEndPos);
        if (indexOfClosingOptionalBracket > 0) {
            fileItegRevEndPos = indexOfClosingOptionalBracket + 1;
        }
        if (fileItegRevEndPos >= baseRevStartPos) {
            return StringUtils.substring((String)itemPathPattern, (int)baseRevStartPos, (int)fileItegRevEndPos);
        }
        return "";
    }

    private static String verifyAndBuildPathPattern(String itemPathPattern) {
        String[] tokens = StringUtils.split((String)itemPathPattern, (String)"/");
        StringBuilder newPathBuilder = new StringBuilder();
        boolean foundBracketToken = false;
        for (String token : tokens) {
            if (StringUtils.containsNone((String)token, (char[])new char[]{'[', ']'})) {
                if (foundBracketToken) {
                    return null;
                }
                newPathBuilder.append(token).append("/");
                foundBracketToken = false;
                continue;
            }
            foundBracketToken = true;
        }
        return newPathBuilder.toString();
    }

    private static String replaceDeclaredFields(ModuleInfo moduleInfo, String itemPathTemplate) {
        HashSet tokens = Sets.newHashSet((Iterable)RepoLayoutUtils.TOKENS);
        Map<String, String> customFields = moduleInfo.getCustomFields();
        if (customFields != null) {
            itemPathTemplate = RepoLayoutUtils.clearCustomTokenRegEx((String)itemPathTemplate);
            tokens.addAll(customFields.keySet());
        }
        for (String token : tokens) {
            BaseTokenFilter tokenFilter;
            String wrappedToken = RepoLayoutUtils.wrapKeywordAsToken((String)token);
            if (!StringUtils.contains((String)itemPathTemplate, (String)wrappedToken)) continue;
            String tokenValue = ModuleInfoUtils.getTokenValue(moduleInfo, token);
            if ("type".equals(token) && StringUtils.isBlank((String)tokenValue)) {
                tokenValue = moduleInfo.getExt();
            }
            if (!StringUtils.isNotBlank((String)tokenValue)) continue;
            if (RepoLayoutUtils.tokenHasFilter((String)token) && (tokenFilter = (BaseTokenFilter)RepoLayoutUtils.TOKEN_FILTERS.get(token)) != null) {
                tokenValue = tokenFilter.forPath(tokenValue);
            }
            itemPathTemplate = StringUtils.replace((String)itemPathTemplate, (String)wrappedToken, (String)tokenValue);
        }
        return itemPathTemplate;
    }

    public static String getTokenValue(ModuleInfo moduleInfo, String tokenName) {
        if ("org".equals(tokenName)) {
            return moduleInfo.getOrganization();
        }
        if ("orgPath".equals(tokenName)) {
            return moduleInfo.getOrganization();
        }
        if ("module".equals(tokenName)) {
            return moduleInfo.getModule();
        }
        if ("baseRev".equals(tokenName)) {
            return moduleInfo.getBaseRevision();
        }
        if ("folderItegRev".equals(tokenName)) {
            return moduleInfo.getFolderIntegrationRevision();
        }
        if ("fileItegRev".equals(tokenName)) {
            return moduleInfo.getFileIntegrationRevision();
        }
        if ("classifier".equals(tokenName)) {
            return moduleInfo.getClassifier();
        }
        if ("ext".equals(tokenName)) {
            return moduleInfo.getExt();
        }
        if ("type".equals(tokenName)) {
            return moduleInfo.getType();
        }
        return moduleInfo.getCustomField(tokenName);
    }

    private static ModuleInfo moduleInfoFromItemPath(String itemPath, RepoLayout repoLayout, boolean descriptor, boolean supportVersionsTokens) {
        if (StringUtils.isBlank((String)itemPath)) {
            throw new IllegalArgumentException("Cannot construct a module info object from a blank item path.");
        }
        if (repoLayout == null) {
            throw new IllegalArgumentException("Cannot construct a module info object from a null repository layout.");
        }
        String pattern = descriptor && repoLayout.isDistinctiveDescriptorPathPattern() ? repoLayout.getDescriptorPathPattern() : repoLayout.getArtifactPathPattern();
        return ModuleInfoUtils.moduleInfoFromPattern(itemPath, repoLayout, pattern, supportVersionsTokens);
    }

    private static ModuleInfo moduleInfoFromPattern(String itemPath, RepoLayout repoLayout, String pattern, boolean supportVersionsTokens) {
        String itemPathPatternRegExp = RepoLayoutUtils.generateRegExpFromPattern((RepoLayout)repoLayout, (String)pattern, (boolean)false, (boolean)supportVersionsTokens);
        NamedPattern itemPathRegExPattern = NamedPattern.compile(itemPathPatternRegExp);
        NamedMatcher itemPathMatcher = itemPathRegExPattern.matcher(itemPath);
        ModuleInfo moduleInfo = !itemPathMatcher.matches() ? new ModuleInfo() : ModuleInfoUtils.createModuleInfo(itemPathMatcher);
        if (!moduleInfo.isValid()) {
            log.debug("Could not transform {} to a valid module info.", (Object)itemPath);
        }
        return moduleInfo;
    }

    private static ModuleInfo createModuleInfo(NamedMatcher itemPathMatcher) {
        Map<String, String> namedGroups = itemPathMatcher.namedGroups();
        ModuleInfoBuilder moduleInfoBuilder = new ModuleInfoBuilder();
        for (Map.Entry<String, String> namedGroupEntry : namedGroups.entrySet()) {
            BaseTokenFilter tokenFilter;
            String groupName = namedGroupEntry.getKey();
            String groupValue = namedGroupEntry.getValue();
            if (RepoLayoutUtils.tokenHasFilter((String)groupName) && (tokenFilter = (BaseTokenFilter)RepoLayoutUtils.TOKEN_FILTERS.get(groupName)) != null) {
                groupValue = tokenFilter.fromPath(groupValue);
            }
            ModuleInfoUtils.setTokenValue(moduleInfoBuilder, groupName, groupValue);
        }
        return moduleInfoBuilder.build();
    }

    private static void setTokenValue(ModuleInfoBuilder moduleInfoBuilder, String tokenName, String tokenValue) {
        if ("org".equals(tokenName)) {
            moduleInfoBuilder.organization(tokenValue);
        } else if ("orgPath".equals(tokenName)) {
            moduleInfoBuilder.organization(tokenValue);
        } else if ("module".equals(tokenName)) {
            moduleInfoBuilder.module(tokenValue);
        } else if ("baseRev".equals(tokenName)) {
            moduleInfoBuilder.baseRevision(tokenValue);
        } else if ("folderItegRev".equals(tokenName)) {
            moduleInfoBuilder.folderIntegrationRevision(tokenValue);
        } else if ("fileItegRev".equals(tokenName)) {
            moduleInfoBuilder.fileIntegrationRevision(tokenValue);
        } else if ("classifier".equals(tokenName)) {
            moduleInfoBuilder.classifier(tokenValue);
        } else if ("ext".equals(tokenName)) {
            moduleInfoBuilder.ext(tokenValue);
        } else if ("type".equals(tokenName)) {
            moduleInfoBuilder.type(tokenValue);
        } else {
            moduleInfoBuilder.customField(tokenName, tokenValue);
        }
    }
}

