/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.maven;

import java.util.ArrayList;
import java.util.List;
import org.artifactory.api.maven.MavenSettingsMirror;
import org.artifactory.api.maven.MavenSettingsRepository;
import org.artifactory.api.maven.MavenSettingsServer;

public class MavenSettings {
    private String url;
    private List<MavenSettingsRepository> releaseRepositories;
    private List<MavenSettingsRepository> pluginRepositories;
    private List<MavenSettingsMirror> mirrorRepositories;
    private List<MavenSettingsServer> servers;

    public MavenSettings(String url) {
        this(url, new ArrayList<MavenSettingsRepository>(), new ArrayList<MavenSettingsRepository>(), new ArrayList<MavenSettingsMirror>(), new ArrayList<MavenSettingsServer>());
    }

    public MavenSettings(String url, List<MavenSettingsRepository> repositories, List<MavenSettingsRepository> pluginRepositories, List<MavenSettingsMirror> mirrorRepositories, List<MavenSettingsServer> servers) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.url = url;
        this.releaseRepositories = repositories;
        this.pluginRepositories = pluginRepositories;
        this.mirrorRepositories = mirrorRepositories;
        this.servers = servers;
    }

    public String getUrl() {
        return this.url;
    }

    public List<MavenSettingsRepository> getReleaseRepositories() {
        return this.releaseRepositories;
    }

    public List<MavenSettingsRepository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    public List<MavenSettingsMirror> getMirrorRepositories() {
        return this.mirrorRepositories;
    }

    public List<MavenSettingsServer> getServers() {
        return this.servers;
    }

    public void addReleaseRepository(MavenSettingsRepository mavenSettingsRepository) {
        this.releaseRepositories.add(mavenSettingsRepository);
    }

    public void addPluginRepository(MavenSettingsRepository mavenSettingsRepository) {
        this.pluginRepositories.add(mavenSettingsRepository);
    }

    public void addMirrorRepository(MavenSettingsMirror mavenSettingsMirror) {
        this.mirrorRepositories.add(mavenSettingsMirror);
    }

    public void addServer(MavenSettingsServer mavenSettingsServer) {
        this.servers.add(mavenSettingsServer);
    }
}

