/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.maven;

import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.artifact.UnitInfo;
import org.artifactory.common.ConstantValues;
import org.artifactory.mime.MavenNaming;
import org.artifactory.mime.NamingUtils;
import org.artifactory.repo.RepoPath;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.jfrog.client.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="maven")
public class MavenArtifactInfo
implements UnitInfo {
    private static final Logger log = LoggerFactory.getLogger(MavenArtifactInfo.class);
    public static final String ROOT = "artifactory-maven-artifact";
    public static final String POM = "pom";
    public static final String JAR = "jar";
    public static final String XML = "xml";
    public static final String MODEL_VERSION = "1.1.0";
    private String artifactType = "maven";
    private String artifactId;
    private String groupId;
    private String version;
    private String modelVersion = ConstantValues.publishMavenMetadataModelVersion.getBoolean() ? "1.1.0" : null;
    private String classifier;
    private String type;

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public MavenArtifactInfo(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "NA", "NA");
    }

    public MavenArtifactInfo(MavenArtifactInfo copy) {
        this(copy.groupId, copy.artifactId, copy.version, copy.classifier, copy.type);
    }

    public MavenArtifactInfo() {
        this("NA", "NA", "NA", "NA", JAR);
    }

    public MavenArtifactInfo(String groupId, String artifactId, String version, String classifier, String type) {
        if (groupId == null || artifactId == null) {
            throw new IllegalArgumentException("Cannot create a maven unit with null groupId or ArtifactId");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = PathUtils.hasText((String)version) ? version : "NA";
        this.classifier = PathUtils.hasText((String)classifier) ? classifier : "NA";
        this.type = PathUtils.hasText((String)type) ? type : JAR;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private boolean hasGroupId() {
        return StringUtils.isNotBlank((String)this.groupId) && !"NA".equals(this.groupId);
    }

    private boolean hasArtifactId() {
        return StringUtils.isNotBlank((String)this.artifactId) && !"NA".equals(this.artifactId);
    }

    private boolean hasVersion() {
        return StringUtils.isNotBlank((String)this.version) && !"NA".equals(this.version);
    }

    @Override
    public boolean isMavenArtifact() {
        return true;
    }

    public String getClassifier() {
        if (!this.hasClassifier()) {
            return null;
        }
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null && !"NA".equals(this.classifier);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean isValid() {
        return this.hasGroupId() && this.hasArtifactId() && this.hasVersion();
    }

    @Override
    public void setPath(String path) {
    }

    @Override
    public String getPath() {
        return this.buildMavenPath();
    }

    public String toString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + (String)(this.classifier != null ? ":" + this.classifier : "") + ":" + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenArtifactInfo that = (MavenArtifactInfo)o;
        return this.artifactId.equals(that.artifactId) && this.classifier.equals(that.classifier) && this.groupId.equals(that.groupId) && this.type.equals(that.type) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.classifier.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static MavenArtifactInfo fromRepoPath(RepoPath repoPath) {
        String type = "NA";
        String classifier = "NA";
        String path = repoPath.getPath();
        String fileName = repoPath.getName();
        LinkedList<String> pathElements = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            pathElements.add(tokenizer.nextToken());
        }
        if (pathElements.size() < 3) {
            log.debug("Cannot build MavenArtifactInfo from '{}'. The groupId, artifactId and version are unreadable.", (Object)repoPath);
            return new MavenArtifactInfo();
        }
        int pos = pathElements.size() - 2;
        Object version = (String)pathElements.get(pos--);
        String artifactId = (String)pathElements.get(pos--);
        StringBuilder groupIdBuff = new StringBuilder();
        while (pos >= 0) {
            if (groupIdBuff.length() != 0) {
                groupIdBuff.insert(0, '.');
            }
            groupIdBuff.insert(0, (String)pathElements.get(pos));
            --pos;
        }
        String groupId = groupIdBuff.toString();
        boolean metaData = NamingUtils.isMetadata((String)fileName);
        if (!metaData) {
            if (MavenNaming.isUniqueSnapshotFileName((String)fileName)) {
                version = StringUtils.remove((String)version, (String)"-SNAPSHOT");
                version = (String)version + "-" + MavenNaming.getUniqueSnapshotVersionTimestampAndBuildNumber((String)fileName);
            }
            type = StringUtils.substring((String)fileName, (int)(artifactId.length() + ((String)version).length() + 2));
            int versionStartIndex = StringUtils.indexOf((String)fileName, (String)"-", (int)artifactId.length()) + 1;
            int classifierStartIndex = StringUtils.indexOf((String)fileName, (String)"-", (int)(versionStartIndex + ((String)version).length()));
            if (classifierStartIndex >= 0) {
                Set<String> customMavenTypes = MavenArtifactInfo.getMavenCustomTypes();
                for (String customMavenType : customMavenTypes) {
                    if (!StringUtils.endsWith((String)fileName, (String)customMavenType)) continue;
                    classifier = StringUtils.remove((String)type, (String)("." + customMavenType));
                    type = customMavenType;
                    break;
                }
                if ("NA".equals(classifier)) {
                    int typeDotStartIndex = StringUtils.lastIndexOf((String)type, (String)".");
                    classifier = StringUtils.substring((String)type, (int)0, (int)typeDotStartIndex);
                    type = StringUtils.substring((String)type, (int)(classifier.length() + 1));
                }
            }
        }
        return new MavenArtifactInfo(groupId, artifactId, (String)version, classifier, type);
    }

    private static Set<String> getMavenCustomTypes() {
        String mvnCustomTypes = ConstantValues.mvnCustomTypes.getString();
        return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])StringUtils.split((String)mvnCustomTypes, (String)",")).stream().map(input -> StringUtils.isBlank((String)input) ? input : StringUtils.trim((String)input)).collect(Collectors.toList()));
    }

    public String getPrettyArtifactId() {
        StringBuilder artifactIdBuilder = new StringBuilder(this.getGroupId()).append(":").append(this.getArtifactId()).append(":").append(this.getVersion());
        String artifactClassifier = this.getClassifier();
        if (StringUtils.isNotBlank((String)artifactClassifier) && !"NA".equals(artifactClassifier)) {
            artifactIdBuilder.append(":").append(artifactClassifier);
        }
        if (StringUtils.isNotBlank((String)this.type) && !"NA".equals(artifactClassifier)) {
            artifactIdBuilder.append(":").append(this.type);
        }
        return artifactIdBuilder.toString();
    }

    private String buildMavenPath() {
        StringBuilder path = new StringBuilder();
        if (this.isValid()) {
            this.addBasePath(path);
            path.append("/").append(this.getArtifactId()).append("-").append(this.getVersion());
            if (this.hasClassifier()) {
                path.append("-").append(this.classifier);
            }
            path.append(".").append(this.type);
        }
        return path.toString();
    }

    private void addBasePath(StringBuilder path) {
        if (this.isValid()) {
            path.append(this.groupId.replace('.', '/')).append("/").append(this.artifactId);
            if (this.hasVersion()) {
                path.append("/").append(this.version);
            }
        }
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }
}

