/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.license;

import java.io.Serializable;
import org.artifactory.api.license.LicenseInfo;

public class ArtifactLicenseModel
implements Serializable {
    public static final String UNAPPROVED = "Unapproved";
    public static final String APPROVED = "Approved";
    private String name;
    private String longName;
    private String url;
    private String comments;
    private String regexp;
    private boolean approved;

    public ArtifactLicenseModel() {
    }

    public ArtifactLicenseModel(LicenseInfo licenseInfo) {
        this.comments = licenseInfo.getComments();
        this.longName = licenseInfo.getLongName();
        this.name = licenseInfo.getName();
        this.url = licenseInfo.getUrl();
        this.regexp = licenseInfo.getRegexp();
        this.approved = licenseInfo.isApproved();
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.isApproved() ? APPROVED : UNAPPROVED;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public void changeStatus() {
        this.setApproved(!this.isApproved());
    }

    public LicenseInfo buildLicenseInfo() {
        LicenseInfo info = new LicenseInfo(this.name, this.longName, this.url);
        info.setApproved(this.approved);
        info.setComments(this.comments);
        info.setRegexp(this.regexp);
        return info;
    }
}

