/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.build;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.artifactory.api.repo.WorkItem;
import org.artifactory.build.BuildRun;

public class BuildRetentionWorkItem
extends WorkItem {
    private final BuildRun buildId;
    private final boolean deleteArtifacts;

    public BuildRetentionWorkItem(BuildRun buildId, boolean deleteArtifacts) {
        this.buildId = Objects.requireNonNull(buildId);
        this.deleteArtifacts = deleteArtifacts;
    }

    @Override
    @Nonnull
    public String getUniqueKey() {
        return this.buildId.toString();
    }

    public BuildRun getBuildId() {
        return this.buildId;
    }

    public boolean isDeleteArtifacts() {
        return this.deleteArtifacts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRetentionWorkItem that = (BuildRetentionWorkItem)o;
        return this.deleteArtifacts == that.deleteArtifacts && Objects.equals(this.buildId, that.buildId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.buildId, this.deleteArtifacts);
    }
}

