/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.rule;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleLayoutToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRulePathToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRulePropertyToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleTokenFactory;
import org.artifactory.descriptor.repo.RepoLayout;
import org.artifactory.descriptor.repo.RepoType;
import org.artifactory.util.RepoLayoutUtils;
import org.artifactory.util.distribution.DistributionConstants;

public enum DistributionRuleTokens {
    BOWER_NAME(RepoType.Bower, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "bower.name")),
    BOWER_VERSION(RepoType.Bower, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "bower.version")),
    COCOAPODS_NAME(RepoType.CocoaPods, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "pods.name")),
    COCOAPODS_VERSION(RepoType.CocoaPods, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "pods.version")),
    CONAN_USER(RepoType.Conan, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_ORG.key)),
    CONAN_NAME(RepoType.Conan, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_MODULE.key)),
    CONAN_VERSION(RepoType.Conan, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_BASE_REVISION.key)),
    CONAN_CHANNEL(RepoType.Conan, () -> new DistributionRuleLayoutToken(Keys.CONAN_CHANNEL.key)),
    DEBIAN_NAME(RepoType.Debian, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "deb.name")),
    DEBIAN_VERSION(RepoType.Debian, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "deb.version")),
    DEBIAN_DISTRIBUTION(RepoType.Debian, () -> new DistributionRulePropertyToken(Keys.DEB_DISTRIBUTION.key, "deb.distribution")),
    DEBIAN_COMPONENT(RepoType.Debian, () -> new DistributionRulePropertyToken(Keys.DEB_COMPONENT.key, "deb.component")),
    DEBIAN_ARCHITECTURE(RepoType.Debian, () -> new DistributionRulePropertyToken(Keys.ARCHITECTURE.key, "deb.architecture")),
    DOCKER_IMAGE(RepoType.Docker, () -> new DistributionRulePropertyToken(Keys.DOCKER_IMAGE.key, "docker.repoName")),
    DOCKER_TAG(RepoType.Docker, () -> new DistributionRulePropertyToken(Keys.DOCKER_TAG.key, "docker.manifest")),
    GRADLE_ORG(RepoType.Gradle, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_ORG.key)),
    GRADLE_MODULE(RepoType.Gradle, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_MODULE.key)),
    GRADLE_BASE_REV(RepoType.Gradle, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_BASE_REVISION.key)),
    GRADLE_CLASSIFIER(RepoType.Gradle, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_CLASSIFIER.key)),
    GRADLE_EXTENSION(RepoType.Gradle, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_EXTENSION.key)),
    IVY_ORG(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_ORG.key)),
    IVY_MODULE(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_MODULE.key)),
    IVY_BASE_REVISION(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_BASE_REVISION.key)),
    IVY_TYPE(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_TYPE.key)),
    IVY_CLASSIFIER(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_CLASSIFIER.key)),
    IVY_EXTENSION(RepoType.Ivy, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_EXTENSION.key)),
    MAVEN_ORG(RepoType.Maven, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_ORG_PATH.key)),
    MAVEN_MODULE(RepoType.Maven, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_MODULE.key)),
    MAVEN_BASE_REVISION(RepoType.Maven, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_BASE_REVISION.key)),
    MAVEN_CLASSIFIER(RepoType.Maven, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_CLASSIFIER.key)),
    MAVEN_EXTENSION(RepoType.Maven, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_EXTENSION.key)),
    NPM_NAME(RepoType.Npm, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "npm.name")),
    NPM_VERSION(RepoType.Npm, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "npm.version")),
    NUGET_NAME(RepoType.NuGet, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "nuget.id")),
    NUGET_VERSION(RepoType.NuGet, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "nuget.version")),
    OPKG_NAME(RepoType.Opkg, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "opkg.name")),
    OPKG_VERSION(RepoType.Opkg, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "opkg.version")),
    OPKG_ARCHITECTURE(RepoType.Opkg, () -> new DistributionRulePropertyToken(Keys.ARCHITECTURE.key, "opkg.architecture")),
    RPM_NAME(RepoType.YUM, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "rpm.metadata.name")),
    RPM_VERSION(RepoType.YUM, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "rpm.metadata.version")),
    RPM_ARCHITECTURE(RepoType.YUM, () -> new DistributionRulePropertyToken(Keys.ARCHITECTURE.key, "rpm.metadata.arch")),
    SBT_ORG(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_ORG.key)),
    SBT_MODULE(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_MODULE.key)),
    SBT_SCALA_VERSION(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_SCALA_VERSION.key)),
    SBT_SBT_VERSION(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_SBT_VERSION.key)),
    SBT_BASE_REVISION(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_BASE_REVISION.key)),
    SBT_TYPE(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_TYPE.key)),
    SBT_CLASSIFIER(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_CLASSIFIER.key)),
    SBT_EXTENSION(RepoType.SBT, () -> new DistributionRuleLayoutToken(Keys.LAYOUT_EXTENSION.key)),
    VAGRANT_NAME(RepoType.Vagrant, () -> new DistributionRulePropertyToken(Keys.PACKAGE_NAME.key, "box_name")),
    VAGRANT_VERSION(RepoType.Vagrant, () -> new DistributionRulePropertyToken(Keys.PACKAGE_VERSION.key, "box_version")),
    VAGRANT_PROVIDER(RepoType.Vagrant, () -> new DistributionRulePropertyToken(Keys.VAGRANT_PROVIDER.key, "box_provider"));

    final RepoType type;
    final DistributionRuleTokenFactory tokenFactory;
    public static final DistributionRuleTokenFactory PRODUCT_NAME_TOKEN_FACTORY;

    private DistributionRuleTokens(RepoType type, DistributionRuleTokenFactory tokenFactory) {
        this.type = type;
        this.tokenFactory = tokenFactory;
    }

    public DistributionRuleToken getToken() {
        return this.tokenFactory.create();
    }

    DistributionRuleTokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    public static DistributionRuleToken getProductNameToken() {
        return PRODUCT_NAME_TOKEN_FACTORY.create();
    }

    public static Set<DistributionRuleToken> tokensByType(RepoType type, @Nullable RepoLayout layout) {
        HashSet<DistributionRuleToken> allTokens = new HashSet<DistributionRuleToken>();
        if (type == null) {
            return allTokens;
        }
        allTokens.add(new DistributionRulePathToken(DistributionConstants.PATH_TOKEN));
        allTokens.addAll(Stream.of(Types.values()).filter((Predicate<Types>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tokensByType$53(org.artifactory.descriptor.repo.RepoType org.artifactory.api.bintray.distribution.rule.DistributionRuleTokens$Types ), (Lorg/artifactory/api/bintray/distribution/rule/DistributionRuleTokens$Types;)Z)((RepoType)type)).findAny().orElse((Types)Types.DUMMY).tokenFactories.stream().map(DistributionRuleTokenFactory::create).collect(Collectors.toSet()));
        if ((type.isMavenGroup() || type.equals((Object)RepoType.Generic)) && layout != null) {
            allTokens.addAll(DistributionRuleTokens.getResolverCompatibleLayoutTokens(layout));
        }
        return allTokens;
    }

    private static List<DistributionRuleTokenFactory> tokensByPackageType(RepoType type) {
        return Stream.of(DistributionRuleTokens.values()).filter(tokenKey -> tokenKey.type.equals((Object)type)).map(DistributionRuleTokens::getTokenFactory).collect(Collectors.toList());
    }

    private static List<DistributionRuleLayoutToken> getResolverCompatibleLayoutTokens(RepoLayout layout) {
        return RepoLayoutUtils.getLayoutTokens((RepoLayout)layout).stream().map(DistributionConstants::stripTokenBrackets).map(DistributionConstants::wrapToken).map(DistributionRuleLayoutToken::new).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$tokensByType$53(RepoType type, Types types) {
        return type.equals((Object)types.repoType);
    }

    static {
        PRODUCT_NAME_TOKEN_FACTORY = () -> new DistributionRulePropertyToken(DistributionConstants.PRODUCT_NAME_TOKEN, "internal.descriptor.product.name");
    }

    public static enum Keys {
        PACKAGE_NAME(DistributionConstants.PACKAGE_NAME_TOKEN),
        PACKAGE_VERSION(DistributionConstants.PACKAGE_VERSION_TOKEN),
        DEB_DISTRIBUTION(DistributionConstants.wrapToken((String)"distribution")),
        DEB_COMPONENT(DistributionConstants.wrapToken((String)"component")),
        CONAN_CHANNEL(DistributionConstants.wrapToken((String)"channel")),
        ARCHITECTURE(DistributionConstants.ARCHITECTURE_TOKEN),
        VAGRANT_PROVIDER(DistributionConstants.wrapToken((String)"boxProvider")),
        LAYOUT_ORG(DistributionConstants.wrapToken((String)"org")),
        LAYOUT_ORG_PATH(DistributionConstants.wrapToken((String)"orgPath")),
        LAYOUT_MODULE(DistributionConstants.MODULE_TOKEN),
        LAYOUT_BASE_REVISION(DistributionConstants.BASE_REV_TOKEN),
        LAYOUT_FOLDER_REVISION(DistributionConstants.wrapToken((String)"folderItegRev")),
        LAYOUT_FILE_REVISION(DistributionConstants.wrapToken((String)"fileItegRev")),
        LAYOUT_CLASSIFIER(DistributionConstants.wrapToken((String)"classifier")),
        LAYOUT_TYPE(DistributionConstants.wrapToken((String)"type")),
        LAYOUT_EXTENSION(DistributionConstants.wrapToken((String)"ext")),
        LAYOUT_SCALA_VERSION(DistributionConstants.wrapToken((String)"scalaVersion")),
        LAYOUT_SBT_VERSION(DistributionConstants.wrapToken((String)"sbtVersion")),
        SCOPE(DistributionConstants.wrapToken((String)"scope")),
        DOCKER_IMAGE(DistributionConstants.DOCKER_IMAGE_TOKEN),
        DOCKER_TAG(DistributionConstants.DOCKER_TAG_TOKEN);

        public final String key;

        private Keys(String key) {
            this.key = key;
        }
    }

    public static enum Types {
        BOWER(RepoType.Bower, DistributionRuleTokens.tokensByPackageType(RepoType.Bower)),
        COCOAPODS(RepoType.CocoaPods, DistributionRuleTokens.tokensByPackageType(RepoType.CocoaPods)),
        CONAN(RepoType.Conan, DistributionRuleTokens.tokensByPackageType(RepoType.Conan)),
        DEBIAN(RepoType.Debian, DistributionRuleTokens.tokensByPackageType(RepoType.Debian)),
        DOCKER(RepoType.Docker, DistributionRuleTokens.tokensByPackageType(RepoType.Docker)),
        GRADLE(RepoType.Gradle, DistributionRuleTokens.tokensByPackageType(RepoType.Gradle)),
        IVY(RepoType.Ivy, DistributionRuleTokens.tokensByPackageType(RepoType.Ivy)),
        MAVEN(RepoType.Maven, DistributionRuleTokens.tokensByPackageType(RepoType.Maven)),
        NPM(RepoType.Npm, DistributionRuleTokens.tokensByPackageType(RepoType.Npm)),
        NUGET(RepoType.NuGet, DistributionRuleTokens.tokensByPackageType(RepoType.NuGet)),
        OPKG(RepoType.Opkg, DistributionRuleTokens.tokensByPackageType(RepoType.Opkg)),
        RPM(RepoType.YUM, DistributionRuleTokens.tokensByPackageType(RepoType.YUM)),
        SBT(RepoType.SBT, DistributionRuleTokens.tokensByPackageType(RepoType.SBT)),
        VAGRANT(RepoType.Vagrant, DistributionRuleTokens.tokensByPackageType(RepoType.Vagrant)),
        DUMMY(null, new ArrayList<DistributionRuleTokenFactory>());

        final RepoType repoType;
        final List<DistributionRuleTokenFactory> tokenFactories;

        private Types(RepoType repoType, List<DistributionRuleTokenFactory> tokenFactories) {
            this.repoType = repoType;
            this.tokenFactories = Collections.unmodifiableList(Lists.newArrayList(tokenFactories));
        }
    }
}

