/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.rule;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleToken;
import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jfrog.client.util.PathUtils;

public class DistributionRulePropertyToken
extends DistributionRuleToken {
    @JsonIgnore
    private String propertyKey;

    public DistributionRulePropertyToken(String token, String key) {
        this.token = token;
        this.propertyKey = key;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public void populateValue(RepoPath path, Properties pathProperties) throws Exception {
        Set values = pathProperties.get(this.propertyKey);
        if (CollectionUtils.isEmpty((Collection)values)) {
            throw new Exception("No value was resolved for property token " + this.token + " on artifact " + path.toPath() + ", which is resolved from property: " + this.propertyKey);
        }
        this.value = PathUtils.collectionToDelimitedString((Iterable)values);
    }

    @Override
    public void populateValue(RepoPath path, Map<String, List<String>> pathProperties) throws Exception {
        List<String> values = pathProperties.get(this.propertyKey);
        if (CollectionUtils.isEmpty(values)) {
            throw new Exception("No value was resolved for property token " + this.token + " on artifact " + path.toPath() + ", which is resolved from property: " + this.propertyKey);
        }
        this.value = PathUtils.collectionToDelimitedString(values);
    }
}

