/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jfrog.bintray.client.api.details.Attribute;
import com.jfrog.bintray.client.api.details.PackageDetails;
import com.jfrog.bintray.client.api.details.RepositoryDetails;
import com.jfrog.bintray.client.api.details.VersionDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.bintray.BintrayUploadInfo;
import org.artifactory.api.bintray.distribution.reporting.DistributionReporter;
import org.artifactory.api.bintray.distribution.resolver.CaptureGroupValues;
import org.artifactory.api.bintray.distribution.resolver.DistributionRuleFilterType;
import org.artifactory.api.bintray.distribution.rule.DistributionRulePropertyToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleToken;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleTokens;
import org.artifactory.api.bintray.exception.DistributionCoordinateResolutionException;
import org.artifactory.descriptor.repo.RepoLayout;
import org.artifactory.descriptor.repo.RepoType;
import org.artifactory.descriptor.repo.distribution.DistributionRepoDescriptor;
import org.artifactory.descriptor.repo.distribution.rule.DistributionCoordinates;
import org.artifactory.descriptor.repo.distribution.rule.DistributionRule;
import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;
import org.artifactory.util.distribution.DistributionConstants;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jfrog.common.config.diff.DiffIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionCoordinatesResolver
extends DistributionCoordinates {
    private static final Logger log = LoggerFactory.getLogger(DistributionCoordinatesResolver.class);
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private static final String REPO_FIELD = "repo";
    private static final String PACKAGE_FIELD = "package";
    private static final String VERSION_FIELD = "version";
    private static final String PATH_FIELD = "path";
    @JsonIgnore
    @DiffIgnore
    public RepoPath artifactPath;
    @JsonIgnore
    @DiffIgnore
    public transient Set<DistributionRuleToken> tokens;
    @JsonIgnore
    @DiffIgnore
    public RepoType type;
    @JsonIgnore
    @DiffIgnore
    public transient BintrayUploadInfo uploadInfo;
    @JsonIgnore
    @DiffIgnore
    public String ruleName;
    @JsonIgnore
    @DiffIgnore
    private Properties pathProperties;
    @JsonIgnore
    @DiffIgnore
    private transient Map<DistributionRuleFilterType, CaptureGroupValues> capturingGroups = this.initCaptureGroups();

    private Map<DistributionRuleFilterType, CaptureGroupValues> initCaptureGroups() {
        HashMap map = Maps.newHashMap();
        Stream.of(DistributionRuleFilterType.values()).forEach(filterType -> map.put(filterType, new CaptureGroupValues()));
        return Collections.unmodifiableMap(map);
    }

    public DistributionCoordinatesResolver(DistributionRule rule, RepoPath path, @Nonnull Properties pathProperties, @Nullable RepoLayout layout) {
        super(rule.getDistributionCoordinates());
        this.artifactPath = path;
        this.type = rule.getType();
        this.tokens = DistributionRuleTokens.tokensByType(this.type, layout);
        this.ruleName = rule.getName();
        this.pathProperties = pathProperties;
    }

    @JsonIgnore
    public BintrayUploadInfo getBintrayUploadInfo() {
        return this.uploadInfo;
    }

    public DistributionCoordinatesResolver resolve(DistributionReporter status) {
        if (this.pathProperties != null) {
            if (DistributionCoordinatesResolver.pathHasDistributionCoordinates(this.pathProperties)) {
                String fullPath = this.artifactPath.toPath();
                status.status(fullPath, "Path " + fullPath + " has pre-existing Bintray distribution coordinates. it will be distributed according to them.", log);
                this.replaceFieldsWithExistingCoordinates(status);
            } else {
                this.populateTokenValues(status);
                this.replaceTokensWithValues(status);
            }
        }
        return this.validateNoTokensLeftInFields(status);
    }

    private void populateTokenValues(DistributionReporter status) {
        for (DistributionRuleToken token : this.tokens) {
            try {
                token.populateValue(this.artifactPath, this.pathProperties);
            }
            catch (Exception e) {
                log.debug("", (Throwable)e);
                status.debug(e.getMessage() + " - in rule " + this.ruleName, log);
            }
        }
    }

    private void replaceFieldsWithExistingCoordinates(DistributionReporter status) {
        this.repo = this.pathProperties.getFirst("bintray.repo");
        this.pkg = this.pathProperties.getFirst("bintray.package");
        this.version = this.pathProperties.getFirst("bintray.version");
        this.path = this.pathProperties.getFirst("bintray.path");
        String fullPath = this.artifactPath.toPath();
        try {
            this.type = RepoType.fromType((String)this.pathProperties.getFirst("distribution.package.type"));
        }
        catch (Exception e) {
            log.debug("", (Throwable)e);
            status.warn(fullPath, "Failed to retrieve artifact type from expected property distribution.package.type. artifact " + fullPath + " will be distributed with the existing coordinates but as a generic type", 404, log);
            this.type = RepoType.Generic;
        }
        try {
            if (this.repo.contains("/")) {
                status.debug("Found old Bintray repo coordinate property for Bintray repo: " + this.repo + ", removing subject from field for resolution for artifact " + fullPath, log);
                this.repo = this.repo.split("/")[1];
            }
        }
        catch (Exception e) {
            log.debug("", (Throwable)e);
            status.warn(fullPath, "Failed to get subject from old bintray repo coordinate property: " + this.repo + ". Artifactory will attempt to use the repo coordinate as-is.", 400, e, log);
        }
        status.debug("Overriding coordinates by rule for path " + this.artifactPath.toPath() + ", based on existing distribution coordinates set on it: repo -> " + this.repo + ", package -> " + this.pkg + ", version -> " + this.version + ", path -> " + this.path, log);
    }

    private void replaceTokensWithValues(DistributionReporter status) {
        try {
            for (DistributionRuleToken token : this.tokens) {
                this.repo = this.replaceTokenInField(token, this.repo, REPO_FIELD, status);
                this.pkg = this.replaceTokenInField(token, this.pkg, PACKAGE_FIELD, status);
                this.version = this.replaceTokenInField(token, this.version, VERSION_FIELD, status);
                this.path = this.replaceTokenInField(token, this.path, PATH_FIELD, status);
            }
            for (DistributionRuleFilterType filterType : DistributionRuleFilterType.values()) {
                if (this.capturingGroups.get((Object)filterType).isEmpty()) continue;
                this.repo = this.replaceCaptureGroupsInField(filterType, this.repo, REPO_FIELD, status);
                this.pkg = this.replaceCaptureGroupsInField(filterType, this.pkg, PACKAGE_FIELD, status);
                this.version = this.replaceCaptureGroupsInField(filterType, this.version, VERSION_FIELD, status);
                this.path = this.replaceCaptureGroupsInField(filterType, this.path, PATH_FIELD, status);
            }
        }
        catch (Exception e) {
            String fullPath = this.artifactPath.toPath();
            status.warn(fullPath, e.getMessage(), 400, e, log);
        }
    }

    private String replaceTokenInField(DistributionRuleToken token, String field, String fieldName, DistributionReporter status) throws DistributionCoordinateResolutionException {
        if (field.contains(token.getToken())) {
            if (token.getValue() == null) {
                String err = "Failing rule " + this.ruleName + " - No value present for token " + token.getToken() + " that was found in field '" + fieldName + "' for artifact " + this.artifactPath.toPath();
                if (token instanceof DistributionRulePropertyToken && !DistributionConstants.PRODUCT_NAME_TOKEN.equals(token.getToken())) {
                    err = err + ". Verify that this package has been indexed and property " + ((DistributionRulePropertyToken)token).getPropertyKey() + " is set correctly.";
                }
                throw new DistributionCoordinateResolutionException(err);
            }
            status.debug("Found token '" + token.getToken() + "' in " + fieldName + " field: '" + field + "' for artifact '" + this.artifactPath.toPath() + "'. replacing with value " + token.getValue(), log);
            Matcher fieldMatcher = Pattern.compile(token.getToken(), 16).matcher(field);
            return fieldMatcher.replaceAll(token.getValue());
        }
        return field;
    }

    private String replaceCaptureGroupsInField(DistributionRuleFilterType filterType, String field, String fieldName, DistributionReporter status) throws DistributionCoordinateResolutionException {
        Matcher capGroupMatcher = filterType.getCaptureGroupPattern().matcher(field);
        while (capGroupMatcher.find()) {
            String group = capGroupMatcher.group(0);
            status.debug("Found group token " + group + "in " + fieldName + " field: '" + field + "' for artifact '" + this.artifactPath.toPath() + "' and rule " + this.ruleName + ". trying to parse group number", log);
            String val = this.getCaptureGroupValue(filterType, group, field, fieldName);
            field = field.replaceAll(Pattern.quote(group), val);
        }
        if ((capGroupMatcher = capGroupMatcher.reset(field)).find()) {
            throw new DistributionCoordinateResolutionException("Couldn't match all capture group tokens in field " + fieldName + ": " + field + ". Failing distribution rule '" + this.ruleName + "' for artifact " + this.artifactPath.toPath() + ".");
        }
        return field;
    }

    private String getCaptureGroupValue(DistributionRuleFilterType filterType, String group, String field, String fieldName) throws DistributionCoordinateResolutionException {
        try {
            if (filterType.isNamedGroup(group)) {
                String groupName = filterType.getGroupName(group);
                return this.capturingGroups.get((Object)filterType).getByName(groupName);
            }
            int groupNum = filterType.getGroupNumber(group);
            return this.capturingGroups.get((Object)filterType).getByNumber(groupNum);
        }
        catch (NoSuchElementException e) {
            throw new DistributionCoordinateResolutionException("No value found for capturing group " + group + " in field " + fieldName + " : " + field + ". Failing distribution rule '" + this.ruleName + "' for artifact '" + this.artifactPath.toPath() + "'.");
        }
    }

    public void addCaptureGroups(DistributionRuleFilterType filterType, Matcher filterMatcher, DistributionReporter status) {
        int groupCount = filterMatcher.groupCount();
        if (groupCount > 0) {
            CaptureGroupValues captureGroupValues = this.capturingGroups.get((Object)filterType);
            for (int i = 1; i <= groupCount; ++i) {
                captureGroupValues.addGroupValue(filterMatcher.group(i));
            }
            Set<String> possibleGroupNames = this.extractCaptureGroupNames(filterMatcher.pattern());
            possibleGroupNames.forEach(groupName -> {
                try {
                    captureGroupValues.addGroupValue((String)groupName, filterMatcher.group((String)groupName));
                }
                catch (IllegalArgumentException e) {
                    log.debug("", (Throwable)e);
                    status.debug("No value found for group named '" + groupName + "': " + e.toString(), log);
                }
            });
        }
    }

    private Set<String> extractCaptureGroupNames(Pattern pattern) {
        HashSet groupNames = Sets.newHashSet();
        Matcher namedGroupMatcher = NAMED_GROUP_PATTERN.matcher(pattern.pattern());
        while (namedGroupMatcher.find()) {
            groupNames.add(namedGroupMatcher.group(1));
        }
        return groupNames;
    }

    private DistributionCoordinatesResolver validateNoTokensLeftInFields(DistributionReporter status) {
        boolean hasTokens = false;
        String fullPath = this.artifactPath.toPath();
        String err = "Coordinate Field %s in rule '" + this.ruleName + "' contains tokens that were not matched: %s for artifact " + fullPath + ", failing this rule.";
        if (DistributionCoordinatesResolver.containsToken(this.repo)) {
            hasTokens = true;
            status.error(fullPath, String.format(err, REPO_FIELD, this.repo), 400, log);
        }
        if (DistributionCoordinatesResolver.containsToken(this.pkg)) {
            hasTokens = true;
            status.error(fullPath, String.format(err, PACKAGE_FIELD, this.pkg), 400, log);
        }
        if (DistributionCoordinatesResolver.containsToken(this.version)) {
            hasTokens = true;
            status.error(fullPath, String.format(err, VERSION_FIELD, this.version), 400, log);
        }
        if (DistributionCoordinatesResolver.containsToken(this.path)) {
            hasTokens = true;
            status.error(fullPath, String.format(err, PATH_FIELD, this.path), 400, log);
        }
        if (hasTokens) {
            return null;
        }
        return this;
    }

    private static boolean containsToken(String field) {
        return DistributionConstants.TOKEN_PATTERN.matcher(field).find() || DistributionRuleFilterType.GENERAL_CAP_GROUP_PATTERN.matcher(field).find();
    }

    @JsonIgnore
    public DistributionCoordinatesResolver populateUploadInfo(DistributionRepoDescriptor descriptor) {
        BintrayUploadInfo info = new BintrayUploadInfo();
        RepositoryDetails btRepo = new RepositoryDetails();
        btRepo.setName(this.repo);
        this.setBintrayRepoType(btRepo);
        btRepo.setOwner(descriptor.getBintrayApplication().getOrg());
        btRepo.setIsPrivate(Boolean.valueOf(descriptor.isDefaultNewRepoPrivate()));
        btRepo.setPremium(Boolean.valueOf(descriptor.isDefaultNewRepoPremium()));
        btRepo.setUpdateExisting(Boolean.valueOf(false));
        info.setRepositoryDetails(btRepo);
        PackageDetails btPkg = new PackageDetails(this.pkg);
        if (CollectionUtils.isNotEmpty((Collection)descriptor.getDefaultLicenses())) {
            btPkg.licenses((List)Lists.newArrayList((Iterable)descriptor.getDefaultLicenses()));
        }
        if (StringUtils.isNotBlank((String)descriptor.getDefaultVcsUrl())) {
            btPkg.vcsUrl(descriptor.getDefaultVcsUrl());
        }
        info.setPackageDetails(btPkg);
        VersionDetails versionDetails = new VersionDetails(this.version);
        versionDetails.setAttributes(this.getWhitelistProperties(descriptor));
        info.setVersionDetails(versionDetails);
        this.uploadInfo = info;
        return this;
    }

    private List<Attribute> getWhitelistProperties(DistributionRepoDescriptor descriptor) {
        return descriptor.getWhiteListedProperties().stream().filter(arg_0 -> ((Properties)this.pathProperties).containsKey(arg_0)).map(propKey -> new Attribute(propKey, Attribute.Type.string, this.getAttributes((String)propKey))).collect(Collectors.toList());
    }

    public static boolean pathHasDistributionCoordinates(Properties pathProperties) {
        return pathProperties.containsKey("bintray.repo") && pathProperties.containsKey("bintray.package") && pathProperties.containsKey("bintray.version") && pathProperties.containsKey("bintray.path");
    }

    private void setBintrayRepoType(RepositoryDetails btRepo) {
        switch (this.type) {
            case YUM: {
                btRepo.setType("rpm");
                break;
            }
            case Maven: 
            case Ivy: 
            case SBT: 
            case Gradle: {
                btRepo.setType("maven");
                break;
            }
            case NuGet: {
                btRepo.setType("nuget");
                break;
            }
            case Vagrant: {
                btRepo.setType("vagrant");
                break;
            }
            case Conan: {
                btRepo.setType("conan");
                break;
            }
            case Debian: {
                btRepo.setType("debian");
                break;
            }
            case Opkg: {
                btRepo.setType("opkg");
                break;
            }
            case Docker: {
                btRepo.setType("docker");
                break;
            }
            default: {
                btRepo.setType("generic");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistributionCoordinatesResolver)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DistributionCoordinatesResolver resolver = (DistributionCoordinatesResolver)((Object)o);
        return this.artifactPath != null ? this.artifactPath.equals(resolver.artifactPath) : resolver.artifactPath == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.artifactPath != null ? this.artifactPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.artifactPath.toPath() + " -> " + this.repo + "/" + this.pkg + "/" + this.version + "/" + this.path;
    }

    private List<String> getAttributes(String propKey) {
        return Lists.newArrayList((Iterable)Optional.ofNullable(this.pathProperties.get(propKey)).orElse(Sets.newHashSet()));
    }
}

