/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.addon.layouts.translate;

import org.artifactory.addon.layouts.translate.TranslatorFilter;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.mime.NamingUtils;
import org.jfrog.client.util.PathUtils;

public class ChecksumTranslatorFilter
implements TranslatorFilter {
    @Override
    public boolean filterRequired(String path) {
        return NamingUtils.isChecksum((String)path);
    }

    @Override
    public String getFilteredContent(String path) {
        ChecksumType checksumType = ChecksumType.forFilePath((String)path);
        if (checksumType == null) {
            return null;
        }
        return checksumType.ext();
    }

    @Override
    public String stripPath(String path) {
        return PathUtils.stripExtension((String)path);
    }

    @Override
    public String applyFilteredContent(String strippedPath, String filteredContent) {
        return strippedPath + filteredContent;
    }
}

