package org.artifactory.api.subscriptions;

import org.artifactory.common.config.StringBasedEnum;

/**
 * @author Alexei Vainshtein
 * @author Roman Kreichman
 */
public enum SubscriptionType implements StringBasedEnum {
    FREE("free"),
    FREE_XRAY("free_xray"),
    PRO_TEAM("pro_team"),
    PRO_TEAM_WITH_AUTH("pro_team_auth_providers"),
    ENTERPRISE_TEAM("enterprise_team"),
    ENTERPRISE_XRAY_TEAM("enterprise_xray_team"),
    ENTERPRISE_PLUS("enterprise_plus");

    private final String value;

    SubscriptionType(String subscriptionType) {
        this.value = subscriptionType.toLowerCase();
    }

    public String getString() {
        return value;
    }
}
