/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.artifactory.aql.AqlException;
import org.artifactory.aql.action.AqlAction;
import org.artifactory.aql.action.AqlActionException;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlRepoProvider;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.AqlLazyResult;
import org.artifactory.aql.result.AqlRestResult;
import org.artifactory.aql.result.rows.AqlRowResult;
import org.artifactory.aql.result.rows.InflatableRow;
import org.artifactory.aql.result.rows.populate.PhysicalFieldResultPopulators;
import org.artifactory.aql.result.rows.populate.ResultPopulationContext;
import org.artifactory.aql.result.rows.populate.RowPopulation;
import org.artifactory.aql.result.rows.populate.RowPopulationContext;
import org.artifactory.aql.util.AqlUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlJsonStreamer
extends AqlRestResult
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(AqlJsonStreamer.class);
    private static final String QUERY_PREFIX = "\n{\n\"results\" : [ ";
    private static final String NUMBER_OF_ROWS = "<NUMBER_OF_ROWS>";
    private static final String QUERY_POSTFIX = " ],\n\"range\" : <NUMBER_OF_ROWS>\n}\n";
    private final ResultSet resultSet;
    private final List<DomainSensitiveField> fields;
    private final long limit;
    private final long offset;
    private final AqlRepoProvider repoProvider;
    private final AqlDomainEnum domain;
    private final boolean skipResultWrapper;
    private final ObjectMapper mapper;
    private final AqlAction action;
    private long rowsCount;
    private Buffer buffer = new Buffer();
    private boolean ended;
    private String mainId = null;
    private AqlRestResult.Row mainRow;

    public AqlJsonStreamer(AqlLazyResult<? extends AqlRowResult> lazyResult) {
        this(lazyResult, false);
    }

    public AqlJsonStreamer(AqlLazyResult<? extends AqlRowResult> lazyResult, boolean skipResultWrapper) {
        super(lazyResult.getPermissionProvider());
        this.repoProvider = lazyResult.getRepoProvider();
        this.resultSet = lazyResult.getResultSet();
        this.fields = lazyResult.getFields();
        this.limit = lazyResult.getLimit();
        this.offset = lazyResult.getOffset();
        this.domain = lazyResult.getDomain();
        this.action = lazyResult.getAction();
        this.mapper = this.createObjectMapper();
        this.skipResultWrapper = skipResultWrapper;
        if (!skipResultWrapper) {
            this.buffer.push(QUERY_PREFIX.getBytes());
        }
    }

    private AqlRestResult.Row inflateRow() {
        try {
            ResultPopulationContext resultContext = new ResultPopulationContext(this.resultSet, this.fields, this.repoProvider);
            while (this.resultSet.next()) {
                InflatableRow row = new InflatableRow();
                RowPopulationContext populationContext = new RowPopulationContext(resultContext, row);
                RowPopulation.populatePhysicalFields(populationContext, PhysicalFieldResultPopulators.forJson);
                RowPopulation.populateLogicalFields(populationContext);
                if (!this.canRead(this.domain, this.resultSet)) continue;
                Map<String, AqlRestResult.Row> map = row.inflate();
                String newId = map.keySet().iterator().next();
                AqlRestResult.Row newRow = map.values().iterator().next();
                if (this.mainId == null) {
                    this.mainId = newId;
                    this.mainRow = newRow;
                    continue;
                }
                if (!this.mainId.equals(newId)) {
                    AqlRestResult.Row temp = this.mainRow;
                    this.mainRow = newRow;
                    this.mainId = newId;
                    AqlRestResult.Row currentRow = this.actOnRow(temp.build());
                    if (currentRow == null) continue;
                    return currentRow;
                }
                this.mainRow.merge(newRow);
            }
        }
        catch (Exception e) {
            throw new AqlException("Failed to fetch Aql result", e);
        }
        if (this.mainRow != null) {
            AqlRestResult.Row row = this.mainRow;
            this.mainRow = null;
            return this.actOnRow(row.build());
        }
        return null;
    }

    @Nullable
    private AqlRestResult.Row actOnRow(AqlRestResult.Row row) {
        try {
            return this.action.doAction(row);
        }
        catch (AqlActionException aae) {
            String warn = (this.action.isDryRun() ? "** AQL dry run mode ** " : "") + aae.getReason().code() + " : " + aae.getMessage();
            log.warn(warn);
            log.debug("", (Throwable)aae);
        }
        catch (Exception e) {
            log.warn(String.format("Failed to execute action %s : {}", this.action.getName()), (Object)e.getMessage());
            log.debug("", (Throwable)e);
        }
        return null;
    }

    @Override
    public byte[] read() {
        if (!this.buffer.isEmpty()) {
            return this.buffer.getData();
        }
        byte[] data = this.getNewRowFromDb();
        if (data != null) {
            ++this.rowsCount;
            this.buffer.push(data);
            return this.buffer.getData();
        }
        if (!this.ended && !this.skipResultWrapper) {
            this.appendEndSection();
            return this.buffer.getData();
        }
        return null;
    }

    private void appendEndSection() {
        try {
            if (!this.ended) {
                String range = this.generateRangeJson();
                String summary = StringUtils.replace((String)QUERY_POSTFIX, (String)NUMBER_OF_ROWS, (String)range);
                this.buffer.push(summary.getBytes());
                this.ended = true;
            }
        }
        catch (IOException e) {
            log.error("Failed to generate Aql result summery.", (Throwable)e);
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRowsCount() {
        return this.rowsCount;
    }

    private String generateRangeJson() throws IOException {
        AqlRestResult.Range range = new AqlRestResult.Range(this.offset, this.rowsCount, this.rowsCount, this.limit);
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)range);
    }

    private byte[] getNewRowFromDb() {
        boolean isFirstElement = this.mainId == null;
        AqlRestResult.Row row = this.inflateRow();
        if (row != null) {
            try {
                Object json = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)row);
                json = isFirstElement || this.skipResultWrapper ? (String)json : "," + (String)json;
                return ((String)json).getBytes();
            }
            catch (Exception e) {
                throw new AqlException("Failed to convert Aql Result to JSON", e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        AqlUtils.closeResultSet(this.resultSet);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper newMapper = new ObjectMapper();
        newMapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        newMapper.setVisibility(JsonMethod.ALL, JsonAutoDetect.Visibility.NONE);
        newMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        return newMapper;
    }

    private class Buffer {
        private byte[] buffer;

        private Buffer() {
        }

        public void push(byte[] bytes) {
            this.buffer = bytes;
        }

        public byte[] getData() {
            byte[] temp = this.buffer;
            this.buffer = null;
            return temp;
        }

        public boolean isEmpty() {
            return this.buffer == null;
        }
    }
}

