/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlFieldEnum;
import org.artifactory.aql.model.AqlFieldEnumSwitch;
import org.artifactory.aql.model.AqlVariableTypeEnum;

public enum AqlPhysicalFieldEnum implements AqlFieldEnum
{
    itemRepo("repo", AqlDomainEnum.items, AqlVariableTypeEnum.string, true),
    itemPath("path", AqlDomainEnum.items, AqlVariableTypeEnum.string, true),
    itemName("name", AqlDomainEnum.items, AqlVariableTypeEnum.string, true),
    itemCreated("created", AqlDomainEnum.items, AqlVariableTypeEnum.date, true),
    itemModified("modified", AqlDomainEnum.items, AqlVariableTypeEnum.date, true),
    itemUpdated("updated", AqlDomainEnum.items, AqlVariableTypeEnum.date, true),
    itemCreatedBy("created_by", AqlDomainEnum.items, AqlVariableTypeEnum.string, true),
    itemModifiedBy("modified_by", AqlDomainEnum.items, AqlVariableTypeEnum.string, true),
    itemType("type", AqlDomainEnum.items, AqlVariableTypeEnum.itemType, true),
    itemDepth("depth", AqlDomainEnum.items, AqlVariableTypeEnum.integer, false),
    itemId("id", AqlDomainEnum.items, AqlVariableTypeEnum.longInt, false),
    itemOriginalMd5("original_md5", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    itemActualMd5("actual_md5", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    itemOriginalSha1("original_sha1", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    itemActualSha1("actual_sha1", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    itemSha2("sha256", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    repoPathChecksum("repo_path_checksum", AqlDomainEnum.items, AqlVariableTypeEnum.string, false),
    itemSize("size", AqlDomainEnum.items, AqlVariableTypeEnum.longInt, true),
    statDownloaded("downloaded", AqlDomainEnum.statistics, AqlVariableTypeEnum.date, true),
    statDownloads("downloads", AqlDomainEnum.statistics, AqlVariableTypeEnum.integer, true),
    statDownloadedBy("downloaded_by", AqlDomainEnum.statistics, AqlVariableTypeEnum.string, true),
    statId("id", AqlDomainEnum.statistics, AqlVariableTypeEnum.longInt, false),
    statRemoteDownloaded("remote_downloaded", AqlDomainEnum.statistics, AqlVariableTypeEnum.date, false),
    statRemoteDownloads("remote_downloads", AqlDomainEnum.statistics, AqlVariableTypeEnum.integer, false),
    statRemoteDownloadedBy("remote_downloaded_by", AqlDomainEnum.statistics, AqlVariableTypeEnum.string, false),
    statRemoteOrigin("remote_origin", AqlDomainEnum.statistics, AqlVariableTypeEnum.string, false),
    statRemotePath("remote_path", AqlDomainEnum.statistics, AqlVariableTypeEnum.string, false),
    statRemoteId("remote_id", AqlDomainEnum.statistics, AqlVariableTypeEnum.longInt, false),
    propertyKey("key", AqlDomainEnum.properties, AqlVariableTypeEnum.string, true),
    propertyValue("value", AqlDomainEnum.properties, AqlVariableTypeEnum.string, true),
    propertyId("id", AqlDomainEnum.properties, AqlVariableTypeEnum.longInt, false),
    propertyItemId("item_id", AqlDomainEnum.properties, AqlVariableTypeEnum.longInt, false),
    archiveEntryName("name", AqlDomainEnum.entries, AqlVariableTypeEnum.string, true),
    archiveEntryPath("path", AqlDomainEnum.entries, AqlVariableTypeEnum.string, true),
    archiveEntryPathId("path_id", AqlDomainEnum.entries, AqlVariableTypeEnum.longInt, false),
    archiveEntryNameId("name_id", AqlDomainEnum.entries, AqlVariableTypeEnum.longInt, false),
    moduleName("name", AqlDomainEnum.modules, AqlVariableTypeEnum.string, true),
    moduleId("id", AqlDomainEnum.modules, AqlVariableTypeEnum.longInt, false),
    buildDependencyName("name", AqlDomainEnum.dependencies, AqlVariableTypeEnum.string, true),
    buildDependencyScope("scope", AqlDomainEnum.dependencies, AqlVariableTypeEnum.string, true),
    buildDependencyType("type", AqlDomainEnum.dependencies, AqlVariableTypeEnum.string, true),
    buildDependencySha1("sha1", AqlDomainEnum.dependencies, AqlVariableTypeEnum.string, false),
    buildDependencyMd5("md5", AqlDomainEnum.dependencies, AqlVariableTypeEnum.string, false),
    buildDependencyId("id", AqlDomainEnum.dependencies, AqlVariableTypeEnum.longInt, false),
    buildArtifactName("name", AqlDomainEnum.artifacts, AqlVariableTypeEnum.string, true),
    buildArtifactType("type", AqlDomainEnum.artifacts, AqlVariableTypeEnum.string, true),
    buildArtifactSha1("sha1", AqlDomainEnum.artifacts, AqlVariableTypeEnum.string, false),
    buildArtifactMd5("md5", AqlDomainEnum.artifacts, AqlVariableTypeEnum.string, false),
    buildArtifactId("id", AqlDomainEnum.artifacts, AqlVariableTypeEnum.longInt, false),
    buildPropertyKey("key", AqlDomainEnum.buildProperties, AqlVariableTypeEnum.string, true),
    buildPropertyValue("value", AqlDomainEnum.buildProperties, AqlVariableTypeEnum.string, true),
    buildPropertyId("id", AqlDomainEnum.buildProperties, AqlVariableTypeEnum.longInt, false),
    buildPromotionCreated("created", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.date, true),
    buildPromotionCreatedBy("created_by", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.string, true),
    buildPromotionStatus("status", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.string, true),
    buildPromotionRepo("repo", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.string, true),
    buildPromotionComment("comment", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.string, true),
    buildPromotionUserName("user", AqlDomainEnum.buildPromotions, AqlVariableTypeEnum.string, true),
    modulePropertyKey("key", AqlDomainEnum.moduleProperties, AqlVariableTypeEnum.string, true),
    modulePropertyValue("value", AqlDomainEnum.moduleProperties, AqlVariableTypeEnum.string, true),
    modulePropertyId("id", AqlDomainEnum.moduleProperties, AqlVariableTypeEnum.longInt, false),
    buildUrl("url", AqlDomainEnum.builds, AqlVariableTypeEnum.string, true),
    buildName("name", AqlDomainEnum.builds, AqlVariableTypeEnum.string, true),
    buildNumber("number", AqlDomainEnum.builds, AqlVariableTypeEnum.string, true),
    buildStarted("started", AqlDomainEnum.builds, AqlVariableTypeEnum.date, true),
    buildCreated("created", AqlDomainEnum.builds, AqlVariableTypeEnum.date, true),
    buildCreatedBy("created_by", AqlDomainEnum.builds, AqlVariableTypeEnum.string, true),
    buildModified("modified", AqlDomainEnum.builds, AqlVariableTypeEnum.date, true),
    buildModifiedBy("modified_by", AqlDomainEnum.builds, AqlVariableTypeEnum.string, true),
    buildId("id", AqlDomainEnum.builds, AqlVariableTypeEnum.longInt, false),
    releaseBundleId("id", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.longInt, true),
    releaseBundleName("name", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleVersion("version", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleStatus("status", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleCreated("created", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.date, true),
    releaseBundleSignature("signature", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleType("type", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleStoringRepo("storing_repo", AqlDomainEnum.releaseBundles, AqlVariableTypeEnum.string, true),
    releaseBundleFileId("id", AqlDomainEnum.releaseBundleFiles, AqlVariableTypeEnum.longInt, true),
    releaseBundleFileNodeId("item_id", AqlDomainEnum.releaseBundleFiles, AqlVariableTypeEnum.longInt, true),
    releaseBundleFileBundleId("bundle_id", AqlDomainEnum.releaseBundleFiles, AqlVariableTypeEnum.longInt, true),
    releaseBundleFileRepoPath("path", AqlDomainEnum.releaseBundleFiles, AqlVariableTypeEnum.string, true);

    private final String signature;
    private final AqlDomainEnum domain;
    private final AqlVariableTypeEnum type;
    private final boolean defaultResultField;
    private static final Set<AqlPhysicalFieldEnum> ID_FIELDS;
    private static final AqlPhysicalFieldEnum[] EMPTY_ARRAY;
    private static final Map<AqlDomainEnum, AqlPhysicalFieldEnum[]> FIELDS_BY_DOMAIN;

    private AqlPhysicalFieldEnum(String signature, AqlDomainEnum domain, AqlVariableTypeEnum type, boolean defaultResultField) {
        this.signature = signature;
        this.domain = domain;
        this.type = type;
        this.defaultResultField = defaultResultField;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public AqlDomainEnum getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isId() {
        return ID_FIELDS.contains(this);
    }

    @Override
    public <T> T doSwitch(AqlFieldEnumSwitch<T> fieldEnumSwitch) {
        return fieldEnumSwitch.caseOf(this);
    }

    public AqlVariableTypeEnum getType() {
        return this.type;
    }

    public boolean isDefaultResultField() {
        return this.defaultResultField;
    }

    static AqlPhysicalFieldEnum[] getFieldsByDomain(AqlDomainEnum domain) {
        AqlPhysicalFieldEnum[] fields = FIELDS_BY_DOMAIN.get((Object)domain);
        if (fields == null) {
            return EMPTY_ARRAY;
        }
        return fields;
    }

    public static boolean isKnownSignature(String signature) {
        signature = signature.toLowerCase();
        for (AqlPhysicalFieldEnum field : AqlPhysicalFieldEnum.values()) {
            if (!field.signature.equals(signature)) continue;
            return true;
        }
        return false;
    }

    static {
        ID_FIELDS = Collections.unmodifiableSet(EnumSet.of(itemId, new AqlPhysicalFieldEnum[]{statId, statRemoteId, propertyId, propertyItemId, moduleId, buildDependencyId, buildArtifactId, buildPropertyId, modulePropertyId, buildId, releaseBundleId, releaseBundleFileId}));
        EMPTY_ARRAY = new AqlPhysicalFieldEnum[0];
        HashMap map = Maps.newHashMap();
        for (AqlPhysicalFieldEnum field : AqlPhysicalFieldEnum.values()) {
            List fields = (List)map.get((Object)field.domain);
            if (fields == null) {
                fields = Lists.newArrayList();
                map.put(field.domain, fields);
            }
            fields.add(field);
        }
        HashMap mapOfArrays = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            List fields = (List)entry.getValue();
            mapOfArrays.put((AqlDomainEnum)((Object)entry.getKey()), fields.toArray(new AqlPhysicalFieldEnum[fields.size()]));
        }
        FIELDS_BY_DOMAIN = Collections.unmodifiableMap(mapOfArrays);
    }
}

