/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import org.artifactory.aql.action.AqlAction;
import org.artifactory.aql.action.AqlDeleteItemAction;
import org.artifactory.aql.action.AqlFindAction;
import org.artifactory.aql.action.AqlUpdateItemPropertyAction;
import org.artifactory.aql.model.AqlDomainEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AqlActionEnum {
    find("find", AqlDomainEnum.items, AqlFindAction.class),
    deleteItem("delete", AqlDomainEnum.items, AqlDeleteItemAction.class),
    updateProperty("update", AqlDomainEnum.properties, AqlUpdateItemPropertyAction.class);

    private static final Logger log;
    private String name;
    private AqlDomainEnum domain;
    private Class<? extends AqlAction> action;

    private AqlActionEnum(String name, AqlDomainEnum domain, Class<? extends AqlAction> action) {
        this.name = name;
        this.domain = domain;
        this.action = action;
    }

    public static AqlAction getAction(String actionName, AqlDomainEnum domain) {
        actionName = actionName.toLowerCase();
        try {
            if (find.name().equals(actionName)) {
                return AqlActionEnum.find.action.newInstance();
            }
            for (AqlActionEnum value : AqlActionEnum.values()) {
                if (!value.name.equals(actionName) || !value.domain.equals((Object)domain)) continue;
                return value.action.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.debug("Unsupported action '" + actionName + "' for domain " + domain, (Throwable)e);
        }
        return null;
    }

    public String actionName() {
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(AqlActionEnum.class);
    }
}

