/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.action;

import org.artifactory.api.context.ContextHelper;
import org.artifactory.api.repo.RepositoryService;
import org.artifactory.api.security.AuthorizationService;
import org.artifactory.aql.action.AqlAction;
import org.artifactory.aql.action.AqlActionException;
import org.artifactory.aql.model.AqlActionEnum;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.result.AqlRestResult;
import org.artifactory.aql.util.AqlUtils;
import org.artifactory.common.StatusHolder;
import org.artifactory.repo.RepoPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlDeleteItemAction
implements AqlAction {
    private static final Logger log = LoggerFactory.getLogger(AqlDeleteItemAction.class);
    private boolean dryRun = true;

    @Override
    public AqlRestResult.Row doAction(AqlRestResult.Row row) throws AqlActionException {
        if (!AqlDomainEnum.items.equals((Object)row.getDomain())) {
            String msg = "Skipping delete action for row, only items domain is supported - row has domain: " + row.getDomain();
            log.debug(msg);
            throw new AqlActionException(msg, AqlActionException.Reason.UNSUPPORTED_FOR_DOMAIN);
        }
        this.doIfNeeded(row);
        return row;
    }

    private void doIfNeeded(AqlRestResult.Row row) throws AqlActionException {
        RepoPath itemPath = AqlUtils.fromAql(row);
        if (this.dryRun) {
            if (!this.getAuthService().canDelete(itemPath)) {
                throw new AqlActionException("User does not have permission to delete item at '" + itemPath.toPath() + "'.", AqlActionException.Reason.ACTION_FAILED);
            }
        } else {
            StatusHolder status = this.getRepoService().undeployMultiTransaction(itemPath);
            if (status.isError()) {
                throw new AqlActionException(status.getLastError().getMessage(), AqlActionException.Reason.ACTION_FAILED);
            }
        }
    }

    @Override
    public String getName() {
        return AqlActionEnum.deleteItem.actionName();
    }

    @Override
    public boolean supportsDomain(AqlDomainEnum domain) {
        return AqlDomainEnum.items.equals((Object)domain);
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    private RepositoryService getRepoService() {
        return ContextHelper.get().beanForType(RepositoryService.class);
    }

    private AuthorizationService getAuthService() {
        return ContextHelper.get().beanForType(AuthorizationService.class);
    }
}

