/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.util.Builder;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.security.MutableUserInfo;
import org.artifactory.security.SaltedPassword;
import org.artifactory.security.UserGroupInfo;
import org.artifactory.security.UserPropertyInfo;

public class UserInfoBuilder
implements Builder<MutableUserInfo> {
    private final String username;
    private SaltedPassword password = new SaltedPassword(null, null);
    private String email = "";
    private boolean admin = false;
    private boolean policyManager = false;
    private boolean watchManager = false;
    private Boolean groupAdmin = false;
    private boolean enabled = true;
    private boolean updatableProfile = false;
    private boolean transientUser = false;
    private Set<UserGroupInfo> groups = new HashSet<UserGroupInfo>();
    private String bintrayAuth;
    private Set<UserPropertyInfo> userPropertyInfos;
    private String privateKey;
    private String publicKey;
    private boolean credentialsExpired;
    private long lastLoginTime;
    private String lastLoginIp;
    private String genPasswordKey;
    private String realm;
    private boolean passwordDisabled;
    private boolean locked;

    public UserInfoBuilder(String username) {
        this.username = username;
    }

    @Override
    public MutableUserInfo build() {
        if (StringUtils.isBlank((String)this.username)) {
            throw new IllegalStateException("User must have a username");
        }
        MutableUserInfo user = InfoFactoryHolder.get().createUser();
        user.setUsername(this.username);
        user.setPassword(this.password);
        user.setEmail(this.email);
        user.setAdmin(this.admin);
        user.setPolicyManager(this.policyManager);
        user.setWatchManager(this.watchManager);
        user.setEnabled(this.enabled);
        user.setUpdatableProfile(this.updatableProfile);
        user.setCredentialsExpired(this.credentialsExpired);
        user.setCredentialsNonExpired(!this.credentialsExpired);
        user.setAccountNonExpired(true);
        user.setAccountNonLocked(true);
        user.setTransientUser(this.transientUser);
        user.setLocked(this.locked);
        user.setGroups(this.groups);
        user.setBintrayAuth(this.bintrayAuth);
        user.setUserProperties(this.userPropertyInfos);
        user.setGroupAdmin(this.groupAdmin);
        user.setPrivateKey(this.privateKey);
        user.setPublicKey(this.publicKey);
        user.setLastLoginTimeMillis(this.lastLoginTime);
        user.setLastLoginClientIp(this.lastLoginIp);
        user.setGenPasswordKey(this.genPasswordKey);
        user.setRealm(this.realm);
        user.setPasswordDisabled(this.passwordDisabled);
        return user;
    }

    public UserInfoBuilder email(String email) {
        this.email = email;
        return this;
    }

    public UserInfoBuilder password(SaltedPassword saltedPassword) {
        this.password = saltedPassword;
        return this;
    }

    public UserInfoBuilder admin(boolean admin) {
        this.admin = admin;
        return this;
    }

    public UserInfoBuilder policyManager(boolean policyManager) {
        this.policyManager = policyManager;
        return this;
    }

    public UserInfoBuilder watchManager(boolean watchManager) {
        this.watchManager = watchManager;
        return this;
    }

    public UserInfoBuilder groupAdmin(Boolean groupAdmin) {
        this.groupAdmin = groupAdmin;
        return this;
    }

    public UserInfoBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UserInfoBuilder updatableProfile(boolean updatableProfile) {
        this.updatableProfile = updatableProfile;
        return this;
    }

    public UserInfoBuilder credentialsExpired(boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
        return this;
    }

    public UserInfoBuilder lastLogin(long time, String ip) {
        this.lastLoginTime = time;
        this.lastLoginIp = ip;
        return this;
    }

    public UserInfoBuilder genPasswordKey(String genPasswordKey) {
        this.genPasswordKey = genPasswordKey;
        return this;
    }

    public UserInfoBuilder transientUser() {
        this.transientUser = true;
        return this;
    }

    public UserInfoBuilder internalGroups(Set<String> groupNames) {
        if (groupNames != null) {
            this.groups(InfoFactoryHolder.get().createGroups(groupNames));
        } else {
            this.groups(null);
        }
        return this;
    }

    public UserInfoBuilder groups(@Nullable Set<UserGroupInfo> groups) {
        this.groups = groups != null ? groups : Collections.emptySet();
        return this;
    }

    public UserInfoBuilder addProp(UserPropertyInfo prop) {
        if (this.userPropertyInfos == null) {
            this.userPropertyInfos = Sets.newHashSet();
        }
        this.userPropertyInfos.add(prop);
        return this;
    }

    public UserInfoBuilder bintrayAuth(String bintrayAuth) {
        this.bintrayAuth = bintrayAuth;
        return this;
    }

    public UserInfoBuilder privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public UserInfoBuilder publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public UserInfoBuilder realm(String realm) {
        this.realm = realm;
        return this;
    }

    public UserInfoBuilder passwordDisabled(boolean passwordDisabled) {
        this.passwordDisabled = passwordDisabled;
        return this;
    }

    public UserInfoBuilder locked(boolean locked) {
        this.locked = locked;
        return this;
    }
}

