/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.security;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.bundle.BundleNameAndRepo;
import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;
import org.artifactory.sapi.common.Lock;
import org.artifactory.security.BuildAcl;
import org.artifactory.security.GroupInfo;
import org.artifactory.security.MutableGroupInfo;
import org.artifactory.security.MutableUserInfo;
import org.artifactory.security.ReleaseBundleAcl;
import org.artifactory.security.RepoAcl;
import org.artifactory.security.UserInfo;

public interface UserGroupService {
    public static final String UI_VIEW_BLOCKED_USER_PROP = "blockUiView";

    public UserInfo currentUser();

    @Nonnull
    public UserInfo findUser(String var1);

    @Nullable
    public UserInfo findUser(String var1, boolean var2);

    public void updateUser(MutableUserInfo var1, boolean var2);

    public void updateUserLastLogin(String var1, long var2, String var4);

    @Lock
    public boolean createUser(MutableUserInfo var1);

    @Lock
    public boolean createUserWithNoUIAccess(MutableUserInfo var1);

    @Lock
    public void deleteUser(String var1);

    public List<UserInfo> getAllUsers(boolean var1);

    public List<UserInfo> getAllUsers(boolean var1, boolean var2);

    public Map<String, Boolean> getAllUsersAndAdminStatus(boolean var1);

    public List<RepoAcl> getRepoPathAcls(RepoPath var1);

    public List<BuildAcl> getBuildPathAcls(String var1, String var2, String var3);

    public List<BuildAcl> getBuildPathAcls(RepoPath var1);

    public List<ReleaseBundleAcl> getReleaseBundleAcls(RepoPath var1);

    public boolean isBuildInPermissions(List<String> var1, List<String> var2, String var3);

    public boolean isReleaseBundleInPermission(List<String> var1, List<String> var2, BundleNameAndRepo var3);

    @Lock
    public void deleteGroup(String var1);

    public List<GroupInfo> getAllGroups();

    public List<String> getAllAdminGroupsNames();

    public List<GroupInfo> getNewUserDefaultGroups();

    public Map<String, GroupInfo> getAllExternalGroups();

    public Map<String, GroupInfo> getAllGroupsByGroupNames(List<String> var1);

    public List<GroupInfo> getInternalGroups();

    public Set<String> getNewUserDefaultGroupsNames();

    public void updateGroup(MutableGroupInfo var1);

    @Lock
    public boolean createGroup(MutableGroupInfo var1);

    @Lock
    public void updateGroupUsers(MutableGroupInfo var1, List<String> var2);

    @Lock
    public void addUsersToGroup(String var1, List<String> var2);

    @Lock
    public void removeUsersFromGroup(String var1, List<String> var2);

    public List<String> findUsersInGroup(String var1);

    public String resetPassword(String var1, String var2, String var3);

    public UserInfo findOrCreateExternalAuthUser(String var1, boolean var2);

    public UserInfo findOrCreateExternalAuthUser(String var1, boolean var2, boolean var3);

    @Nullable
    public GroupInfo findGroup(String var1);

    public String createEncryptedPasswordIfNeeded(UserInfo var1, String var2);

    public Properties findPropertiesForUser(String var1);

    public boolean addUserProperty(String var1, String var2, String var3);

    public String getUserProperty(String var1, String var2);

    public void deleteUserProperty(String var1, String var2);

    public boolean updateUserProperty(String var1, String var2, String var3);

    public void deletePropertyFromAllUsers(String var1);

    public String getPropsToken(String var1, String var2);

    @Lock
    public boolean revokePropsToken(String var1, String var2);

    @Lock
    public boolean createPropsToken(String var1, String var2, String var3);

    @Lock
    public void revokeAllPropsTokens(String var1);

    @Lock
    public boolean updatePropsToken(String var1, String var2, String var3);

    public void lockUser(@Nonnull String var1);

    public void unlockUser(@Nonnull String var1);

    public void unlockAllUsers();

    public void registerIncorrectLoginAttempt(@Nonnull String var1);

    public void resetIncorrectLoginAttempts(@Nonnull String var1);

    public Set<String> getLockedUsers();

    public ImmutableSetMultimap<String, String> getAllUsersInGroups();

    public boolean adminUserExists();
}

