/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.property;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.artifactory.api.search.SearchControlsBase;

public class PropertySearchControls
extends SearchControlsBase {
    private LinkedHashMultimap<String, String> properties;
    private LinkedHashMultimap<Boolean, String> propertyOpenIndication;
    public static final boolean OPEN = true;
    public static final boolean CLOSED = false;

    public PropertySearchControls() {
        this.properties = LinkedHashMultimap.create();
        this.propertyOpenIndication = LinkedHashMultimap.create();
    }

    public PropertySearchControls(PropertySearchControls propertySearchControls) {
        this.properties = propertySearchControls.properties;
        this.propertyOpenIndication = propertySearchControls.propertyOpenIndication;
        this.selectedRepoForSearch = propertySearchControls.selectedRepoForSearch;
        this.setLimitSearchResults(propertySearchControls.isLimitSearchResults());
    }

    public LinkedHashMultimap<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> get(String key) {
        return this.properties.get((Object)key);
    }

    public boolean put(String key, String value, boolean isPropertyOpen) {
        boolean propertyAdded = this.properties.put((Object)key, (Object)value);
        boolean indicationAdded = this.propertyOpenIndication.put((Object)isPropertyOpen, (Object)key);
        return propertyAdded && indicationAdded;
    }

    public void removeAll(String key) {
        if (this.propertyOpenIndication.containsEntry((Object)true, (Object)key)) {
            this.propertyOpenIndication.remove((Object)true, (Object)key);
        } else if (this.propertyOpenIndication.containsEntry((Object)false, (Object)key)) {
            this.propertyOpenIndication.remove((Object)false, (Object)key);
        }
        this.properties.removeAll((Object)key);
    }

    public Collection<String> values() {
        return this.properties.values();
    }

    public Set<Map.Entry<String, String>> entries() {
        return this.properties.entries();
    }

    public Multiset<String> keys() {
        return this.properties.keys();
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean isWildcardsOnly() {
        if (this.isEmpty()) {
            return true;
        }
        for (String key : this.properties.keys()) {
            if (!this.isWildcardsOnly(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(String key, String value) {
        return this.properties.containsEntry((Object)key, (Object)value);
    }

    public String getValue() {
        StringBuilder builder = new StringBuilder();
        Iterator keyIterator = this.properties.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            builder.append(key).append("=");
            builder.append("{");
            Iterator valueIterator = this.properties.get((Object)key).iterator();
            while (valueIterator.hasNext()) {
                String value = (String)valueIterator.next();
                builder.append(value);
                if (!valueIterator.hasNext()) continue;
                builder.append(";");
            }
            builder.append("}");
            if (!keyIterator.hasNext()) continue;
            builder.append(" , ");
        }
        return builder.toString();
    }

    public boolean isMapInitialized() {
        return this.properties != null;
    }

    public Set<String> getPropertyKeysByOpenness(boolean openness) {
        return this.propertyOpenIndication.get((Object)openness);
    }
}

