/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.artifact;

import java.util.EnumMap;
import lombok.Generated;
import org.artifactory.api.search.SearchControlsBase;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.common.ConstantValues;

public class ChecksumSearchControls
extends SearchControlsBase {
    private EnumMap<ChecksumType, String> checksums;
    private int limit;

    @Override
    public boolean isEmpty() {
        return this.checksums == null || this.checksums.isEmpty();
    }

    @Override
    public boolean isWildcardsOnly() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.checksums != null) {
            for (String checksum : this.checksums.values()) {
                if (!this.isWildcardsOnly(checksum)) continue;
                return true;
            }
        }
        return false;
    }

    public EnumMap<ChecksumType, String> getChecksums() {
        return this.checksums;
    }

    public void addChecksum(ChecksumType checksumType, String checksumValue) {
        if (this.checksums == null) {
            this.checksums = new EnumMap(ChecksumType.class);
        }
        this.checksums.put(checksumType, checksumValue);
    }

    public void clearChecksums() {
        if (this.checksums != null) {
            this.checksums.clear();
        }
    }

    public int getLimit() {
        return this.limit > 0 ? this.limit : ConstantValues.searchUserQueryLimit.getInt();
    }

    @Generated
    public void setChecksums(EnumMap<ChecksumType, String> checksums) {
        this.checksums = checksums;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChecksumSearchControls)) {
            return false;
        }
        ChecksumSearchControls other = (ChecksumSearchControls)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumMap<ChecksumType, String> this$checksums = this.getChecksums();
        EnumMap<ChecksumType, String> other$checksums = other.getChecksums();
        if (this$checksums == null ? other$checksums != null : !((Object)this$checksums).equals(other$checksums)) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChecksumSearchControls;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumMap<ChecksumType, String> $checksums = this.getChecksums();
        result = result * 59 + ($checksums == null ? 43 : ((Object)$checksums).hashCode());
        result = result * 59 + this.getLimit();
        return result;
    }

    @Generated
    public String toString() {
        return "ChecksumSearchControls(checksums=" + this.getChecksums() + ", limit=" + this.getLimit() + ")";
    }
}

