/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search.archive;

import org.apache.commons.lang.StringUtils;
import org.artifactory.api.search.SearchControlsBase;

public class ArchiveSearchControls
extends SearchControlsBase {
    private String path;
    private String name;
    private boolean excludeInnerClasses;
    private boolean shouldCalcEntries;
    private boolean searchClassResourcesOnly;

    public ArchiveSearchControls() {
        this.excludeInnerClasses = false;
        this.shouldCalcEntries = true;
        this.searchClassResourcesOnly = false;
    }

    public ArchiveSearchControls(ArchiveSearchControls archiveSearchControls) {
        this.path = archiveSearchControls.path;
        this.name = archiveSearchControls.name;
        this.selectedRepoForSearch = archiveSearchControls.selectedRepoForSearch;
        this.setLimitSearchResults(archiveSearchControls.isLimitSearchResults());
        this.excludeInnerClasses = archiveSearchControls.excludeInnerClasses;
        this.shouldCalcEntries = archiveSearchControls.shouldCalcEntries;
        this.searchClassResourcesOnly = archiveSearchControls.searchClassResourcesOnly;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.path) && StringUtils.isEmpty((String)this.name);
    }

    @Override
    public boolean isWildcardsOnly() {
        return this.isWildcardsOnly(this.path) && this.isWildcardsOnly(this.name);
    }

    public boolean isExcludeInnerClasses() {
        return this.excludeInnerClasses;
    }

    public void setExcludeInnerClasses(boolean excludeInnerClasses) {
        this.excludeInnerClasses = excludeInnerClasses;
    }

    public boolean shouldCalcEntries() {
        return this.shouldCalcEntries;
    }

    public void setShouldCalcEntries(boolean shouldCalcEntries) {
        this.shouldCalcEntries = shouldCalcEntries;
    }

    public boolean isSearchClassResourcesOnly() {
        return this.searchClassResourcesOnly;
    }

    public void setSearchClassResourcesOnly(boolean searchClassResourcesOnly) {
        this.searchClassResourcesOnly = searchClassResourcesOnly;
    }

    public String getQueryDisplay() {
        return (String)(StringUtils.isNotEmpty((String)this.getPath()) && !this.isWildcardsOnly(this.getPath()) ? this.getPath() + "/" : "") + (StringUtils.isNotEmpty((String)this.getName()) ? this.getName() : "");
    }
}

