/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.util.SessionIgnoreEncrypt;
import org.artifactory.fs.FileInfo;

@SessionIgnoreEncrypt
public class SavedSearchResults
implements Serializable {
    private final String name;
    private final Set<RepoAgnosticFileInfo> results;

    public SavedSearchResults(String name, List<FileInfo> results) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Empty results name is not allowed");
        }
        this.name = name;
        this.results = Sets.newHashSet();
        if (results != null) {
            this.addAll(results);
        }
    }

    public String getName() {
        return this.name;
    }

    public void merge(SavedSearchResults toMerge) {
        this.results.addAll(toMerge.results);
    }

    public void subtract(SavedSearchResults toSubtract) {
        this.results.removeAll(toSubtract.results);
    }

    public void intersect(SavedSearchResults toIntersect) {
        this.results.retainAll(toIntersect.results);
    }

    public void discardFromResult(SavedSearchResults toDiscardFromResult) {
        this.results.removeAll(toDiscardFromResult.results);
    }

    public ImmutableList<FileInfo> getResults() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RepoAgnosticFileInfo result : this.results) {
            builder.add((Object)result.fileInfo);
        }
        return builder.build();
    }

    public void addAll(Collection<FileInfo> fileInfos) {
        this.results.addAll(this.toRepoAgnosticSet(fileInfos));
    }

    public void removeAll(Collection<FileInfo> fileInfos) {
        this.results.removeAll(this.toRepoAgnosticSet(fileInfos));
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    boolean contains(FileInfo fileInfo) {
        return this.results.contains(new RepoAgnosticFileInfo(fileInfo));
    }

    void add(FileInfo fileInfo) {
        this.results.add(new RepoAgnosticFileInfo(fileInfo));
    }

    private Set<RepoAgnosticFileInfo> toRepoAgnosticSet(Collection<FileInfo> fileInfos) {
        HashSet agnostics = Sets.newHashSet();
        for (FileInfo fileInfo : fileInfos) {
            agnostics.add(new RepoAgnosticFileInfo(fileInfo));
        }
        return agnostics;
    }

    private static class RepoAgnosticFileInfo
    implements Serializable {
        private FileInfo fileInfo;

        private RepoAgnosticFileInfo(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepoAgnosticFileInfo that = (RepoAgnosticFileInfo)o;
            return this.fileInfo.getRelPath() != null ? this.fileInfo.getRelPath().equals(that.fileInfo.getRelPath()) : that.fileInfo.getRelPath() == null;
        }

        public int hashCode() {
            return this.fileInfo.getRelPath() != null ? this.fileInfo.getRelPath().hashCode() : 0;
        }
    }
}

