/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.release;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonProperty;

public class ReleaseBundleResult {
    private List<ReleaseBundleItem> results = Lists.newArrayList();

    public List<ReleaseBundleItem> getResults() {
        return this.results;
    }

    public void setResults(List<ReleaseBundleItem> results) {
        this.results = results;
    }

    public static class ReleaseBundleItemXrayInfo {
        private boolean blocked;
        @JsonProperty(value="blocked_reason")
        @Nullable
        private String blockedReason;

        @Generated
        public boolean isBlocked() {
            return this.blocked;
        }

        @Nullable
        @Generated
        public String getBlockedReason() {
            return this.blockedReason;
        }

        @Generated
        public void setBlocked(boolean blocked) {
            this.blocked = blocked;
        }

        @Generated
        public void setBlockedReason(@Nullable String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReleaseBundleItemXrayInfo)) {
                return false;
            }
            ReleaseBundleItemXrayInfo other = (ReleaseBundleItemXrayInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBlocked() != other.isBlocked()) {
                return false;
            }
            String this$blockedReason = this.getBlockedReason();
            String other$blockedReason = other.getBlockedReason();
            return !(this$blockedReason == null ? other$blockedReason != null : !this$blockedReason.equals(other$blockedReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReleaseBundleItemXrayInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBlocked() ? 79 : 97);
            String $blockedReason = this.getBlockedReason();
            result = result * 59 + ($blockedReason == null ? 43 : $blockedReason.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReleaseBundleResult.ReleaseBundleItemXrayInfo(blocked=" + this.isBlocked() + ", blockedReason=" + this.getBlockedReason() + ")";
        }

        @Generated
        public ReleaseBundleItemXrayInfo() {
        }

        @ConstructorProperties(value={"blocked", "blockedReason"})
        @Generated
        public ReleaseBundleItemXrayInfo(boolean blocked, @Nullable String blockedReason) {
            this.blocked = blocked;
            this.blockedReason = blockedReason;
        }
    }

    public static class ReleaseBundleItem {
        private String urn;
        private String sha256;
        private Map<String, List<String>> properties = new HashMap<String, List<String>>();
        private String signature;
        @JsonProperty(value="pkg_type")
        private String pkgType;
        @JsonProperty(value="pkg_name")
        private String pkgName;
        @JsonProperty(value="pkg_version")
        private String pkgVersion;
        private long size;
        @JsonProperty(value="xray_scan_info")
        private ReleaseBundleItemXrayInfo xrayScanInfo;

        public ReleaseBundleItem(String urn, String sha256, Map<String, List<String>> properties, String signature, String pkgType, String pkgName, String pkgVersion, long size) {
            this.urn = urn;
            this.sha256 = sha256;
            this.properties = properties;
            this.signature = signature;
            this.pkgType = pkgType;
            this.pkgName = pkgName;
            this.pkgVersion = pkgVersion;
            this.size = size;
        }

        public ReleaseBundleItem(String urn, String pkgType, long size) {
            this.urn = urn;
            this.pkgType = pkgType;
            this.size = size;
        }

        public ReleaseBundleItem() {
        }

        public String getUrn() {
            return this.urn;
        }

        public void setUrn(String urn) {
            this.urn = urn;
        }

        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        public Map<String, List<String>> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, List<String>> properties) {
            this.properties = properties;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public String getPkgType() {
            return this.pkgType;
        }

        public void setPkgType(String pkgType) {
            this.pkgType = pkgType;
        }

        public String getPkgName() {
            return this.pkgName;
        }

        public void setPkgName(String pkgName) {
            this.pkgName = pkgName;
        }

        public String getPkgVersion() {
            return this.pkgVersion;
        }

        public void setPkgVersion(String pkgVersion) {
            this.pkgVersion = pkgVersion;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public ReleaseBundleItemXrayInfo getXrayScanInfo() {
            return this.xrayScanInfo;
        }

        public void setXrayScanInfo(ReleaseBundleItemXrayInfo xrayScanInfo) {
            this.xrayScanInfo = xrayScanInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReleaseBundleItem that = (ReleaseBundleItem)o;
            return Objects.equals(this.urn, that.urn);
        }

        public int hashCode() {
            return Objects.hash(this.urn);
        }
    }
}

