/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.common.model.continues.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.artifactory.api.rest.common.model.continues.ContinueIndexPage;
import org.artifactory.api.rest.common.model.continues.ContinueResult;
import org.artifactory.api.rest.common.model.continues.FetchFunction;

public class PagingUtils {
    private PagingUtils() {
    }

    public static <T> ContinueResult<T> getPagingFromMultipleFunctions(ContinueIndexPage continueState, List<FetchFunction<T>> fetchFunctions) {
        return PagingUtils.getPagingFromMultipleFunctions(continueState.getContinueIndex(), continueState.getLimit(), fetchFunctions);
    }

    static <T> ContinueResult<T> getPagingFromMultipleFunctions(long totalOffset, long pageSize, List<FetchFunction<T>> functions) {
        int functionIndex = 0;
        int scannedCount = 0;
        int howMuchGot = 0;
        long startAt = totalOffset;
        long resultContinueIndex = totalOffset;
        ArrayList data = Lists.newArrayList();
        while ((long)howMuchGot < pageSize && functionIndex < functions.size()) {
            FetchFunction<T> fetchFunction;
            long functionDataSize;
            if (startAt > (long)(scannedCount = (int)((long)scannedCount + (functionDataSize = (fetchFunction = functions.get(functionIndex++)).getOriginalSize().longValue())))) continue;
            long offset = startAt == 0L ? 0L : functionDataSize - (long)scannedCount + startAt;
            long limit = (int)(pageSize - (long)howMuchGot);
            ContinueResult<T> continueResult = fetchFunction.getFunction().apply((int)offset, (int)limit);
            List<T> currentList = continueResult.getData();
            data.addAll(currentList);
            howMuchGot = data.size();
            startAt = 0L;
            if (howMuchGot <= 0) continue;
            resultContinueIndex = (long)scannedCount - functionDataSize + (long)Integer.parseInt(continueResult.getContinueState());
        }
        String continueState = (long)data.size() < pageSize ? null : "" + resultContinueIndex;
        return new ContinueResult(continueState, data);
    }
}

