/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.blob;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Generated;
import org.artifactory.descriptor.repo.RepoType;
import org.artifactory.mime.MimeType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jfrog.common.ArgUtils;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ClosestBlobInfoRequest {
    @JsonProperty
    private String checksum;
    @JsonProperty(value="component_type")
    private RepoType componentType;
    @JsonProperty(value="component_name")
    private String componentName;
    @JsonProperty(value="component_version")
    private String componentVersion;
    @JsonProperty(value="component_mimetype")
    private String componentMimetype;
    @JsonProperty(value="artifact_name")
    private String artifactName;

    private ClosestBlobInfoRequest(String checksum, String mimeType, RepoType componentType, String componentName, String componentVersion, String artifactName) {
        this.checksum = ArgUtils.requireNonBlank((String)checksum, (String)"Checksum is required");
        this.componentType = componentType;
        this.componentName = componentName;
        this.componentVersion = componentVersion;
        this.artifactName = ArgUtils.requireNonBlank((String)artifactName, (String)"Artifact name is required");
        this.componentMimetype = mimeType == null || mimeType.isEmpty() ? MimeType.def.getType() : mimeType;
    }

    public void validate() {
        ArgUtils.requireNonBlank((String)this.checksum, (String)"Checksum is required");
        ArgUtils.requireNonBlank((String)this.artifactName, (String)"Artifact name is required");
        ArgUtils.requireNonBlank((String)this.componentMimetype, (String)"Component Mime Type is required");
    }

    public String getChecksum() {
        return this.checksum;
    }

    public RepoType getComponentType() {
        return this.componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getComponentMimetype() {
        return this.componentMimetype;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "ClosestBlobInfoRequest(checksum=" + this.getChecksum() + ", componentType=" + this.getComponentType() + ", componentName=" + this.getComponentName() + ", componentVersion=" + this.getComponentVersion() + ", componentMimetype=" + this.getComponentMimetype() + ", artifactName=" + this.getArtifactName() + ")";
    }

    @Generated
    public ClosestBlobInfoRequest() {
    }

    public static class Builder {
        private String checksum;
        private RepoType componentType;
        private String componentName;
        private String componentVersion;
        private String componentMimetype;
        private String artifactName;

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setComponentType(RepoType componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder setComponentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public Builder setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public Builder setArtifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public Builder setComponentMimetype(String mimeType) {
            this.componentMimetype = mimeType;
            return this;
        }

        public ClosestBlobInfoRequest build() {
            return new ClosestBlobInfoRequest(this.checksum, this.componentMimetype, this.componentType, this.componentName, this.componentVersion, this.artifactName);
        }
    }
}

