/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.repo;

import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;

public class BrowsableItemCriteria {
    private final RepoPath repoPath;
    private final boolean includeChecksums;
    private final boolean includeRemoteResources;
    private final Properties requestProperties;

    private BrowsableItemCriteria(RepoPath repoPath, boolean includeChecksums, boolean includeRemoteResources, Properties requestProperties) {
        this.repoPath = repoPath;
        this.includeChecksums = includeChecksums;
        this.includeRemoteResources = includeRemoteResources;
        this.requestProperties = requestProperties;
    }

    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    public boolean isIncludeChecksums() {
        return this.includeChecksums;
    }

    public boolean isIncludeRemoteResources() {
        return this.includeRemoteResources;
    }

    public Properties getRequestProperties() {
        return this.requestProperties;
    }

    public static class Builder {
        private RepoPath repoPath;
        private boolean includeChecksums = true;
        private boolean includeRemoteResources = true;
        private Properties requestProperties;

        public Builder(RepoPath repoPath) {
            this.repoPath = repoPath;
        }

        public Builder(BrowsableItemCriteria copy) {
            this.repoPath = copy.getRepoPath();
            this.includeChecksums = copy.isIncludeChecksums();
            this.includeRemoteResources = copy.isIncludeRemoteResources();
            this.requestProperties = copy.getRequestProperties();
        }

        public Builder repoPath(RepoPath repoPath) {
            this.repoPath = repoPath;
            return this;
        }

        public Builder includeChecksums(boolean includeChecksums) {
            this.includeChecksums = includeChecksums;
            return this;
        }

        public Builder includeRemoteResources(boolean includeRemoteResources) {
            this.includeRemoteResources = includeRemoteResources;
            return this;
        }

        public Builder requestProperties(Properties requestProperties) {
            this.requestProperties = requestProperties;
            return this;
        }

        public BrowsableItemCriteria build() {
            if (this.repoPath == null) {
                throw new IllegalArgumentException("Please provide a repo path.");
            }
            return new BrowsableItemCriteria(this.repoPath, this.includeChecksums, this.includeRemoteResources, this.requestProperties);
        }
    }
}

