/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.build;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class GeneralBuild {
    private long buildId;
    private String buildName;
    private String buildNumber;
    private long buildDate;
    private String ciUrl;
    private long created;
    private String createdBy;
    private long modified;
    private String modifiedBy;
    private String numOfModules;
    private String numOfArtifacts;
    private String numOfDependencies;
    private String status;
    private Long promotionCreated;

    public GeneralBuild(long buildId, String buildName, String buildNumber, long buildDate, String ciUrl, long created, String createdBy, long modified, String modifiedBy) {
        if (buildId <= 0L) {
            throw new IllegalArgumentException("Build id cannot be zero or negative!");
        }
        if (StringUtils.isBlank((String)buildName) || StringUtils.isBlank((String)buildNumber) || buildDate <= 0L) {
            throw new IllegalArgumentException("Build name, number and date cannot be empty or null!");
        }
        if (created <= 0L) {
            throw new IllegalArgumentException("Created date cannot be zero or negative!");
        }
        this.buildId = buildId;
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
        this.ciUrl = ciUrl;
        this.created = created;
        this.createdBy = createdBy;
        this.modified = modified;
        this.modifiedBy = modifiedBy;
    }

    public GeneralBuild(String buildName, String buildNumber, long buildDate, String ciUrl, String status) {
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
        this.ciUrl = ciUrl;
        this.status = status;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public long getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(long buildDate) {
        this.buildDate = buildDate;
    }

    public String getCiUrl() {
        return this.ciUrl;
    }

    public void setCiUrl(String ciUrl) {
        this.ciUrl = ciUrl;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getModified() {
        return this.modified;
    }

    public void setModified(long modified) {
        this.modified = modified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getNumOfModules() {
        return this.numOfModules;
    }

    public void setNumOfModules(String numOfModules) {
        this.numOfModules = numOfModules;
    }

    public String getNumOfArtifacts() {
        return this.numOfArtifacts;
    }

    public void setNumOfArtifacts(String numOfArtifacts) {
        this.numOfArtifacts = numOfArtifacts;
    }

    public String getNumOfDependencies() {
        return this.numOfDependencies;
    }

    public void setNumOfDependencies(String numOfDependencies) {
        this.numOfDependencies = numOfDependencies;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getPromotionCreated() {
        return this.promotionCreated;
    }

    public void setPromotionCreated(Long promotionCreated) {
        this.promotionCreated = promotionCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralBuild that = (GeneralBuild)o;
        return this.buildDate == that.buildDate && this.buildName.equals(that.buildName) && this.buildNumber.equals(that.buildNumber);
    }

    public int hashCode() {
        return Objects.hash(this.buildName, this.buildNumber, this.buildDate);
    }
}

