/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class CaptureGroupValues {
    private final List<String> values = Lists.newArrayList();
    private final Map<String, String> namedValues = Maps.newHashMap();

    CaptureGroupValues() {
    }

    public void addGroupValue(String value) {
        this.values.add(value);
    }

    public void addGroupValue(String groupName, String value) {
        this.namedValues.put(groupName, value);
    }

    public String getByName(String groupName) throws NoSuchElementException {
        if (this.namedValues.containsKey(groupName)) {
            return this.namedValues.get(groupName);
        }
        throw new NoSuchElementException("No such named group: " + groupName);
    }

    public String getByNumber(int groupNumber) throws NoSuchElementException {
        int groupIndex = groupNumber - 1;
        if (0 <= groupIndex && groupIndex < this.values.size()) {
            return this.values.get(groupIndex);
        }
        throw new NoSuchElementException("No such group number: " + groupNumber);
    }

    public boolean isEmpty() {
        return this.values.isEmpty() && this.namedValues.isEmpty();
    }
}

