/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.log.logback;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.artifactory.common.ArtifactoryHome;
import org.jfrog.common.logging.logback.LogbackContextConfigurator;
import org.jfrog.common.logging.logback.servlet.LoggerConfigInfo;

public class ArtifactoryLoggerConfigInfo
extends LoggerConfigInfo {
    private final ArtifactoryHome artifactoryHome;

    public ArtifactoryLoggerConfigInfo(String contextId, ArtifactoryHome artifactoryHome) {
        super(contextId, artifactoryHome.getLogbackConfig());
        this.artifactoryHome = artifactoryHome;
    }

    protected void configure(LogbackContextConfigurator configurator) {
        super.configure(configurator);
        configurator.property("artifactory.contextId", this.normalizedContextId()).property("artifactory.home", this.artifactoryHome.getHomeDir().getAbsolutePath());
        String customProps = this.artifactoryHome.getArtifactoryProperties().getProperty("artifactory.test.logback.custom", "");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customProps)) {
            String[] customParams = customProps.split(",");
            Arrays.stream(customParams).forEach(p -> configurator.property(p.split("::")[0], p.split("::")[1]));
        }
    }

    private String normalizedContextId() {
        String contextId = StringUtils.trimToEmpty((String)this.getContextId());
        contextId = "artifactory".equalsIgnoreCase(contextId) ? "" : contextId + " ";
        return StringUtils.isBlank((String)contextId) ? "" : contextId.toLowerCase();
    }
}

