/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.context.ContextHelper;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.api.repo.RepositoryService;
import org.artifactory.api.security.AuthorizationService;
import org.artifactory.aql.AqlService;
import org.artifactory.aql.api.domain.sensitive.AqlApiItem;
import org.artifactory.aql.api.internal.AqlBase;
import org.artifactory.aql.result.AqlEagerResult;
import org.artifactory.aql.result.AqlRestResult;
import org.artifactory.aql.result.rows.AqlBaseFullRowImpl;
import org.artifactory.aql.result.rows.AqlItem;
import org.artifactory.aql.util.AqlSearchablePath;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;
import org.artifactory.repo.RepoPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlUtils {
    private static final Logger log = LoggerFactory.getLogger(AqlUtils.class);

    public static RepoPath fromAql(String repo, String path, String name) {
        if (StringUtils.equals((String)path, (String)".")) {
            return RepoPathFactory.create((String)repo, (String)name);
        }
        return RepoPathFactory.create((String)repo, (String)(path + "/" + name));
    }

    public static RepoPath fromAql(AqlItem row) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)row.getRepo()) || StringUtils.isBlank((String)row.getPath()) || StringUtils.isBlank((String)row.getName())) {
            throw new IllegalArgumentException("Repo, Path, and Name fields must contain values");
        }
        return AqlUtils.fromAql(row.getRepo(), row.getPath(), row.getName());
    }

    public static RepoPath fromAql(AqlRestResult.Row row) throws IllegalArgumentException {
        String err = "Repo, Path, and Name fields must contain values";
        if (row == null) {
            throw new IllegalArgumentException(err);
        }
        if (StringUtils.isBlank((String)row.itemRepo) || StringUtils.isBlank((String)row.itemPath) || StringUtils.isBlank((String)row.itemName)) {
            throw new IllegalArgumentException(err);
        }
        return AqlUtils.fromAql(row.itemRepo, row.itemPath, row.itemName);
    }

    public static boolean exists(RepoPath path) {
        AqlSearchablePath aqlPath = new AqlSearchablePath(path);
        AqlApiItem aql = (AqlApiItem)AqlApiItem.create().filter(AqlBase.and(AqlApiItem.repo().equal(aqlPath.getRepo()), AqlApiItem.path().equal(aqlPath.getPath()), AqlApiItem.name().equal(aqlPath.getFileName())));
        AqlEagerResult<AqlItem> results = ContextHelper.get().beanForType(AqlService.class).executeQueryEager(aql);
        return results != null && results.getResults() != null && results.getResults().size() > 0;
    }

    public static List<AqlSearchablePath> getSearchablePathForCurrentFolderAndSubfolders(RepoPath path) {
        ArrayList artifactPaths = Lists.newArrayList();
        RepoPath searchPath = InternalRepoPathFactory.childRepoPath((RepoPath)path, (String)"*.*");
        AqlSearchablePath allFilesInCurrentFolder = new AqlSearchablePath(searchPath);
        allFilesInCurrentFolder.setFileName("*");
        artifactPaths.add(allFilesInCurrentFolder);
        artifactPaths.add(AqlUtils.getSearchablePathForAllFilesInSubfolders(path));
        return artifactPaths;
    }

    public static AqlSearchablePath getSearchablePathForAllFilesInSubfolders(RepoPath path) {
        RepoPath searchPath = InternalRepoPathFactory.childRepoPath((RepoPath)path, (String)"*.*");
        AqlSearchablePath allFilesInSubFolders = new AqlSearchablePath(searchPath);
        if (".".equals(allFilesInSubFolders.getPath())) {
            allFilesInSubFolders.setPath("**");
        } else {
            allFilesInSubFolders.setPath(allFilesInSubFolders.getPath() + "/**");
        }
        allFilesInSubFolders.setFileName("*");
        return allFilesInSubFolders;
    }

    public static AqlBase.OrClause<AqlApiItem> getSearchClauseForPaths(List<AqlSearchablePath> aqlSearchablePaths) {
        AqlBase.OrClause<AqlApiItem> searchClause = AqlBase.or();
        for (AqlSearchablePath path : aqlSearchablePaths) {
            log.debug("Adding path '{}' to artifact search", (Object)path.toRepoPath().toString());
            searchClause.append(AqlBase.and(AqlApiItem.repo().equal(path.getRepo()), AqlApiItem.path().matches(path.getPath()), AqlApiItem.name().matches(path.getFileName()), AqlApiItem.depth().greaterEquals(path.getPath().split("/").length)));
        }
        return searchClause;
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.trace("Could not close JDBC result set", (Throwable)e);
            }
            catch (Exception e) {
                log.trace("Unexpected exception when closing JDBC result set", (Throwable)e);
            }
        }
    }

    public static HashMultimap<RepoPath, AqlBaseFullRowImpl> aggregateResultsByPath(List<AqlBaseFullRowImpl> results) {
        AuthorizationService authService = ContextHelper.get().getAuthorizationService();
        HashMultimap aggregator = HashMultimap.create();
        results.forEach(result -> {
            RepoPath path = AqlUtils.fromAql(result);
            if (authService.canRead(path)) {
                aggregator.put((Object)path, result);
            } else {
                log.debug("Path '{}' omitted from results due to missing read permissions for user: '{}'", (Object)path.toPath(), (Object)authService.currentUsername());
            }
        });
        return aggregator;
    }

    public static List<AqlItem> aggregateRowByPermission(List<AqlItem> results) {
        AuthorizationService authService = ContextHelper.get().getAuthorizationService();
        RepositoryService repositoryService = ContextHelper.get().getRepositoryService();
        ArrayList list = Lists.newArrayList();
        results.forEach(result -> {
            RepoPath repoPath = AqlUtils.fromAql(result);
            if (authService.canRead(repoPath) && !AqlUtils.isDistributionRepo(repositoryService, repoPath)) {
                list.add(result);
            } else {
                log.debug("Path '{}' omitted from results due to missing read permissions for user: '{}'", (Object)repoPath.toPath(), (Object)authService.currentUsername());
            }
        });
        return list;
    }

    private static boolean isDistributionRepo(RepositoryService repositoryService, RepoPath repoPath) {
        return repositoryService.distributionRepoDescriptorByKey(repoPath.getRepoKey()) != null;
    }

    public static HashMultimap<String, AqlBaseFullRowImpl> aggregateResultsPackage(List<AqlBaseFullRowImpl> results) {
        AuthorizationService authService = ContextHelper.get().getAuthorizationService();
        RepositoryService repositoryService = ContextHelper.get().getRepositoryService();
        HashMultimap aggregator = HashMultimap.create();
        results.forEach(result -> {
            RepoPath repoPath = RepoPathFactory.create((String)result.getRepo(), (String)result.getValue());
            if (authService.canRead(repoPath) && !AqlUtils.isDistributionRepo(repositoryService, repoPath)) {
                aggregator.put((Object)result.getValue(), result);
            } else {
                log.debug("Path '{}' omitted from results due to missing read permissions for user: '{}'", (Object)repoPath.toPath(), (Object)authService.currentUsername());
            }
        });
        return aggregator;
    }

    public static AqlApiItem getRecursiveFindItemQuery(RepoPath pathToSearch, String artifactName) {
        AqlApiItem aql = pathToSearch.getPath().equals("") || pathToSearch.getPath().equals(".") ? (AqlApiItem)AqlApiItem.create().filter(AqlApiItem.and(AqlApiItem.repo().equal(pathToSearch.getRepoKey()), AqlApiItem.path().matches(pathToSearch.getPath() + "*"), AqlApiItem.name().equal(artifactName))) : (AqlApiItem)AqlApiItem.create().filter(AqlApiItem.and(AqlApiItem.repo().equal(pathToSearch.getRepoKey()), AqlApiItem.name().equal(artifactName), AqlApiItem.or(AqlApiItem.path().matches(pathToSearch.getPath() + "/*"), AqlApiItem.path().equal(pathToSearch.getPath()))));
        return aql;
    }

    public static AqlApiItem getAllDirectChildrenOfParentQuery(RepoPath repoPath) {
        if (repoPath == null) {
            log.debug("Empty repoPath. Unable to construct query");
            return null;
        }
        if (repoPath.getParent() == null) {
            log.debug("Empty Parent. Unable to construct query");
            return null;
        }
        return (AqlApiItem)AqlApiItem.create().filter(AqlBase.and(AqlApiItem.repo().equal(repoPath.getRepoKey()), AqlApiItem.path().equal(repoPath.getParent().getPath())));
    }

    public static Optional<AqlApiItem> getDirectChildrenByModuleAndVersionQuery(@Nonnull RepoPath repoPath, ModuleInfo moduleInfo) {
        if (repoPath.getParent() == null) {
            log.debug("Empty Parent. Unable to construct query");
            return Optional.empty();
        }
        AqlBase.AndClause<AqlApiItem> repoPathAndNameCriteria = AqlBase.and(AqlApiItem.repo().equal(repoPath.getRepoKey()), AqlApiItem.path().equal(repoPath.getParent().getPath()));
        String baseRevision = moduleInfo.getBaseRevision();
        String module = moduleInfo.getModule();
        if (moduleInfo.isIntegration()) {
            String fileIntegrationRevision = moduleInfo.getFileIntegrationRevision();
            repoPathAndNameCriteria.append(AqlApiItem.name().matches(module + "-" + baseRevision + "-" + fileIntegrationRevision + "*"));
        } else {
            repoPathAndNameCriteria.append(AqlApiItem.name().matches(module + "-" + baseRevision + "*"));
        }
        return Optional.of(AqlApiItem.create().filter(repoPathAndNameCriteria));
    }

    @SafeVarargs
    public static <E> E[] arrayOf(E ... elements) {
        return elements;
    }
}

