/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows.populate;

import java.sql.SQLException;
import java.util.Date;
import java.util.function.Function;
import org.artifactory.aql.model.AqlItemTypeEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.rows.populate.FieldResultPopulator;
import org.artifactory.aql.result.rows.populate.RowPopulationContext;
import org.joda.time.format.ISODateTimeFormat;

public class PhysicalFieldResultPopulator
implements FieldResultPopulator {
    public static final Function<Long, Object> toISODateString = value -> value == 0L ? null : ISODateTimeFormat.dateTime().print(value.longValue());
    public static final Function<Long, Object> toDateObject = value -> value == 0L ? null : new Date((long)value);
    private final Function<Long, Object> dateLongToValueFunction;

    public PhysicalFieldResultPopulator(Function<Long, Object> dateLongToValueFunction) {
        this.dateLongToValueFunction = dateLongToValueFunction;
    }

    @Override
    public void populate(RowPopulationContext populationContext, DomainSensitiveField field) throws SQLException {
        AqlPhysicalFieldEnum physicalFieldEnum = (AqlPhysicalFieldEnum)field.getField();
        String dbFieldName = physicalFieldEnum.name();
        switch (physicalFieldEnum.getType()) {
            case date: {
                this.populateDate(populationContext, field, dbFieldName);
                break;
            }
            case longInt: {
                this.populateLong(populationContext, field, dbFieldName);
                break;
            }
            case integer: {
                this.populateInt(populationContext, field, dbFieldName);
                break;
            }
            case string: {
                this.populateString(populationContext, field, dbFieldName);
                break;
            }
            case itemType: {
                this.populateItemType(populationContext, field, dbFieldName);
            }
        }
    }

    private void populateLong(RowPopulationContext populationContext, DomainSensitiveField field, String dbFieldName) throws SQLException {
        long value = populationContext.getResultSet().getLong(dbFieldName);
        populationContext.getRow().put(field, value);
    }

    private void populateString(RowPopulationContext populationContext, DomainSensitiveField field, String dbFieldName) throws SQLException {
        String value = populationContext.getResultSet().getString(dbFieldName);
        populationContext.getRow().put(field, value);
    }

    private void populateInt(RowPopulationContext populationContext, DomainSensitiveField field, String dbFieldName) throws SQLException {
        int value = populationContext.getResultSet().getInt(dbFieldName);
        populationContext.getRow().put(field, value);
    }

    private void populateItemType(RowPopulationContext populationContext, DomainSensitiveField field, String dbFieldName) throws SQLException {
        int type = populationContext.getResultSet().getInt(dbFieldName);
        AqlItemTypeEnum aqlItemTypeEnum = AqlItemTypeEnum.fromTypes(type);
        populationContext.getRow().put(field, (Object)aqlItemTypeEnum);
    }

    private void populateDate(RowPopulationContext populationContext, DomainSensitiveField field, String dbFieldName) throws SQLException {
        Long valueLong = populationContext.getResultSet().getLong(dbFieldName);
        Object value = this.dateLongToValueFunction.apply(valueLong);
        populationContext.getRow().put(field, value);
    }
}

