/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows;

import java.sql.ResultSet;
import org.artifactory.aql.result.AqlLazyResult;
import org.artifactory.aql.result.rows.AqlRowResult;
import org.artifactory.aql.result.rows.RowResult;
import org.artifactory.aql.result.rows.populate.PhysicalFieldResultPopulators;
import org.artifactory.aql.result.rows.populate.ResultPopulationContext;
import org.artifactory.aql.result.rows.populate.RowPopulation;
import org.artifactory.aql.result.rows.populate.RowPopulationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqlLazyObjectResultStreamer<T extends RowResult> {
    private static final Logger log = LoggerFactory.getLogger(AqlLazyObjectResultStreamer.class);
    private final ResultSet resultSet;
    private final Class<T> rowClass;
    private final ResultPopulationContext resultContext;

    public AqlLazyObjectResultStreamer(AqlLazyResult<? extends AqlRowResult> aqlLazyResult, Class<T> rowClass) {
        this.rowClass = rowClass;
        this.resultSet = aqlLazyResult.getResultSet();
        this.resultContext = new ResultPopulationContext(this.resultSet, aqlLazyResult.getFields(), aqlLazyResult.getRepoProvider());
    }

    public T getRow() {
        try {
            RowResult row = (RowResult)this.rowClass.newInstance();
            if (this.resultSet.next()) {
                RowPopulationContext populationContext = new RowPopulationContext(this.resultContext, row);
                RowPopulation.populatePhysicalFields(populationContext, PhysicalFieldResultPopulators.forObjects);
                RowPopulation.populateLogicalFields(populationContext);
                return (T)row;
            }
        }
        catch (Exception e) {
            log.error("Fail to create row: ", (Throwable)e);
        }
        return null;
    }
}

