/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.artifactory.aql.AqlException;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlItemTypeEnum;
import org.artifactory.aql.model.AqlPermissionProvider;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.util.AqlUtils;
import org.artifactory.repo.RepoPath;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AqlRestResult
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AqlRestResult.class);
    private AqlPermissionProvider permissionProvider;

    AqlRestResult(AqlPermissionProvider permissionProvider) {
        this.permissionProvider = permissionProvider;
    }

    protected boolean canRead(AqlDomainEnum domain, ResultSet resultSet) {
        if (this.permissionProvider.isAdmin()) {
            return true;
        }
        if (AqlDomainEnum.items == domain) {
            try {
                String itemRepo = resultSet.getString(AqlPhysicalFieldEnum.itemRepo.name());
                String itemPath = resultSet.getString(AqlPhysicalFieldEnum.itemPath.name());
                String itemName = resultSet.getString(AqlPhysicalFieldEnum.itemName.name());
                RepoPath repoPath = AqlUtils.fromAql(itemRepo, itemPath, itemName);
                return this.permissionProvider.canRead(repoPath);
            }
            catch (Exception e) {
                this.logMinimalFieldError(e);
            }
        }
        return false;
    }

    protected boolean canRead(AqlDomainEnum domain, String repo, String path, String name) {
        if (this.permissionProvider.isAdmin()) {
            return true;
        }
        if (AqlDomainEnum.items == domain) {
            try {
                RepoPath repoPath = AqlUtils.fromAql(repo, path, name);
                return this.permissionProvider.canRead(repoPath);
            }
            catch (Exception e) {
                this.logMinimalFieldError(e);
            }
        }
        return false;
    }

    public abstract byte[] read();

    private void logMinimalFieldError(Exception e) {
        log.error("AQL minimal field expectation error: repo, path and name", (Throwable)e);
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonPropertyOrder(value={"start", "end", "total"}, alphabetic=true)
    protected class Range {
        @JsonProperty(value="start_pos")
        protected Long start;
        @JsonProperty(value="end_pos")
        protected Long end;
        @JsonProperty(value="total")
        protected Long total;
        @JsonProperty(value="limit")
        protected Long limited;

        public Range(long start, long end, long limited) {
            this.start = start;
            this.end = end;
            this.limited = Long.MAX_VALUE == limited ? null : Long.valueOf(limited);
        }

        public Range(long start, long end, long total, long limited) {
            this.start = start;
            this.end = end;
            this.total = total;
            this.limited = Long.MAX_VALUE == limited ? null : Long.valueOf(limited);
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonPropertyOrder(value={"itemRepo", "itemPath", "itemName", "itemType", "itemSize", "itemCreated", "itemCreatedBy", "itemModified", "itemModifiedBy", "itemUpdated", "itemDepth"}, alphabetic=true)
    public static class Row {
        @JsonIgnore
        public Map<String, Row> subDomains;
        @JsonIgnore
        public AqlDomainEnum domain;
        @JsonIgnore
        public Long statId;
        @JsonIgnore
        public Long itemId;
        @JsonIgnore
        public Long propertyId;
        @JsonIgnore
        public Long propertyItemId;
        @JsonIgnore
        public Long buildId;
        @JsonIgnore
        public Long buildPropertyId;
        @JsonIgnore
        public Long buildArtifactId;
        @JsonIgnore
        public Long modulePropertyId;
        @JsonIgnore
        public Long moduleId;
        @JsonIgnore
        public Long buildDependencyId;
        @JsonIgnore
        public Long archiveEntryPathId;
        @JsonIgnore
        public Long statRemoteId;
        @JsonIgnore
        public Long releaseBundleFileId;
        @JsonIgnore
        public Long releaseBundleFileNodeId;
        @JsonIgnore
        public Long releaseBundleFileBundleId;
        @JsonProperty(value="repo")
        public String itemRepo;
        @JsonProperty(value="path")
        public String itemPath;
        @JsonProperty(value="name")
        public String itemName;
        @JsonProperty(value="size")
        public Long itemSize;
        @JsonProperty(value="depth")
        public Integer itemDepth;
        @JsonProperty(value="modified")
        public String itemModified;
        @JsonProperty(value="created")
        public String itemCreated;
        @JsonProperty(value="updated")
        public String itemUpdated;
        @JsonProperty(value="created_by")
        public String itemCreatedBy;
        @JsonProperty(value="modified_by")
        public String itemModifiedBy;
        @JsonProperty(value="type")
        public AqlItemTypeEnum itemType;
        @JsonProperty(value="virtual_repos")
        public String[] itemVirtualRepos;
        @JsonProperty(value="original_md5")
        public String itemOriginalMd5;
        @JsonProperty(value="actual_md5")
        public String itemActualMd5;
        @JsonProperty(value="original_sha1")
        public String itemOriginalSha1;
        @JsonProperty(value="actual_sha1")
        public String itemActualSha1;
        @JsonProperty(value="sha256")
        public String itemSha2;
        @JsonProperty(value="repo_path_checksum")
        public String repoPathChecksum;
        @JsonProperty(value="downloaded")
        public String statDownloaded;
        @JsonProperty(value="downloads")
        public Integer statDownloads;
        @JsonProperty(value="downloaded_by")
        public String statDownloadedBy;
        @JsonProperty(value="remote_downloaded_by")
        public String statRemoteDownloadedBy;
        @JsonProperty(value="remote_downloads")
        public Integer statRemoteDownloads;
        @JsonProperty(value="remote_downloaded")
        public String statRemoteDownloaded;
        @JsonProperty(value="remote_path")
        public String statRemotePath;
        @JsonProperty(value="remote_origin")
        public String statRemoteOrigin;
        @JsonProperty(value="key")
        public String propertyKey;
        @JsonProperty(value="value")
        public String propertyValue;
        @JsonProperty(value="entry.name")
        public String archiveEntryName;
        @JsonProperty(value="entry.path")
        public String archiveEntryPath;
        @JsonProperty(value="module.name")
        public String moduleName;
        @JsonProperty(value="module.property.key")
        public String modulePropertyKey;
        @JsonProperty(value="module.property.value")
        public String modulePropertyValue;
        @JsonProperty(value="dependency.name")
        public String buildDependencyName;
        @JsonProperty(value="dependency.scope")
        public String buildDependencyScope;
        @JsonProperty(value="dependency.type")
        public String buildDependencyType;
        @JsonProperty(value="dependency.sha1")
        public String buildDependencySha1;
        @JsonProperty(value="dependency.md5")
        public String buildDependencyMd5;
        @JsonProperty(value="artifact.name")
        public String buildArtifactName;
        @JsonProperty(value="artifact.type")
        public String buildArtifactType;
        @JsonProperty(value="artifact.sha1")
        public String buildArtifactSha1;
        @JsonProperty(value="artifact.md5")
        public String buildArtifactMd5;
        @JsonProperty(value="build.property.key")
        public String buildPropertyKey;
        @JsonProperty(value="build.property.value")
        public String buildPropertyValue;
        @JsonProperty(value="build.url")
        public String buildUrl;
        @JsonProperty(value="build.name")
        public String buildName;
        @JsonProperty(value="build.number")
        public String buildNumber;
        @JsonProperty(value="build.started")
        public String buildStarted;
        @JsonProperty(value="build.created")
        public String buildCreated;
        @JsonProperty(value="build.created_by")
        public String buildCreatedBy;
        @JsonProperty(value="build.modified")
        public String buildModified;
        @JsonProperty(value="build.modified_by")
        public String buildModifiedBy;
        @JsonProperty(value="build.promotion.created")
        public String buildPromotionCreated;
        @JsonProperty(value="build.promotion.created_by")
        public String buildPromotionCreatedBy;
        @JsonProperty(value="build.promotion.user")
        public String buildPromotionUserName;
        @JsonProperty(value="build.promotion.status")
        public String buildPromotionStatus;
        @JsonProperty(value="build.promotion.repo")
        public String buildPromotionRepo;
        @JsonProperty(value="build.promotion.comment")
        public String buildPromotionComment;
        @JsonProperty(value="release.name")
        public String releaseBundleName;
        @JsonProperty(value="release.version")
        public String releaseBundleVersion;
        @JsonProperty(value="release.status")
        public String releaseBundleStatus;
        @JsonProperty(value="release.created")
        public String releaseBundleCreated;
        @JsonProperty(value="release.signature")
        public String releaseBundleSignature;
        @JsonProperty(value="release.type")
        public String releaseBundleType;
        @JsonProperty(value="release_artifact.repo_path")
        public String releaseBundleFileRepoPath;
        @JsonProperty(value="items")
        public List<Row> items;
        @JsonProperty(value="properties")
        public List<Row> properties;
        @JsonProperty(value="stats")
        public List<Row> statistics;
        @JsonProperty(value="archives")
        public List<Row> archives;
        @JsonProperty(value="entries")
        public List<Row> entries;
        @JsonProperty(value="artifacts")
        public List<Row> artifacts;
        @JsonProperty(value="dependencies")
        public List<Row> dependencies;
        @JsonProperty(value="modules")
        public List<Row> modules;
        @JsonProperty(value="module.properties")
        public List<Row> moduleProperties;
        @JsonProperty(value="builds")
        public List<Row> builds;
        @JsonProperty(value="build.properties")
        public List<Row> buildProperties;
        @JsonProperty(value="build.promotions")
        public List<Row> buildPromotions;
        @JsonProperty(value="releaseBundles")
        public List<Row> releaseBundles;
        @JsonProperty(value="releaseBundleFiles")
        public List<Row> releaseBundleFiles;

        public Row(AqlDomainEnum domain) {
            this.domain = domain;
        }

        public void put(String fieldName, Object value) {
            try {
                Field declaredField = this.getClass().getDeclaredField(fieldName);
                declaredField.setAccessible(true);
                declaredField.set(this, value);
            }
            catch (Exception e) {
                log.error("Failed to fill Aql result {}: with value: {}", (Object)fieldName, value);
                log.debug("Failed to fill Aql result {}: with value: {}", new Object[]{fieldName, value, e});
            }
        }

        public void merge(Row row) {
            this.merge(row, this);
        }

        private boolean merge(Row source, Row target) {
            boolean containsData = this.mapFields(source, target);
            boolean childContainsData = false;
            if (source.subDomains != null) {
                for (String id : source.subDomains.keySet()) {
                    Row targetSubRow;
                    Row sourceSubRow = source.subDomains.get(id);
                    if (target.subDomains == null) {
                        target.subDomains = Maps.newHashMap();
                    }
                    if ((targetSubRow = target.subDomains.get(id)) == null) {
                        targetSubRow = new Row(sourceSubRow.getDomain());
                        target.subDomains.put(id, targetSubRow);
                    }
                    if (childContainsData = this.merge(sourceSubRow, targetSubRow)) continue;
                    target.subDomains.remove(id);
                }
            }
            return containsData || childContainsData;
        }

        private boolean mapFields(Row source, Row target) {
            boolean containsData = false;
            try {
                Field[] declaredFields;
                for (Field declaredField : declaredFields = source.getClass().getFields()) {
                    if (declaredField.getName().equals("subDomains") || declaredField.getName().equals("domain")) continue;
                    Object value = declaredField.get(source);
                    containsData = true;
                    declaredField.set(target, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new AqlException("failed to map result fields", e);
            }
            return containsData;
        }

        public Row build() {
            if (this.subDomains != null) {
                for (Row row : this.subDomains.values()) {
                    row.build();
                    AqlDomainEnum domainEnum = row.getDomain();
                    switch (domainEnum) {
                        case items: {
                            if (this.items == null) {
                                this.items = Lists.newArrayList();
                            }
                            this.items.add(row);
                            break;
                        }
                        case properties: {
                            if (this.properties == null) {
                                this.properties = Lists.newArrayList();
                            }
                            this.properties.add(row);
                            break;
                        }
                        case statistics: {
                            if (this.statistics == null) {
                                this.statistics = Lists.newArrayList();
                            }
                            this.statistics.add(row);
                            break;
                        }
                        case archives: {
                            if (this.archives == null) {
                                this.archives = Lists.newArrayList();
                            }
                            this.archives.add(row);
                            break;
                        }
                        case entries: {
                            if (this.entries == null) {
                                this.entries = Lists.newArrayList();
                            }
                            this.entries.add(row);
                            break;
                        }
                        case artifacts: {
                            if (this.artifacts == null) {
                                this.artifacts = Lists.newArrayList();
                            }
                            this.artifacts.add(row);
                            break;
                        }
                        case dependencies: {
                            if (this.dependencies == null) {
                                this.dependencies = Lists.newArrayList();
                            }
                            this.dependencies.add(row);
                            break;
                        }
                        case modules: {
                            if (this.modules == null) {
                                this.modules = Lists.newArrayList();
                            }
                            this.modules.add(row);
                            break;
                        }
                        case moduleProperties: {
                            if (this.moduleProperties == null) {
                                this.moduleProperties = Lists.newArrayList();
                            }
                            this.moduleProperties.add(row);
                            break;
                        }
                        case builds: {
                            if (this.builds == null) {
                                this.builds = Lists.newArrayList();
                            }
                            this.builds.add(row);
                            break;
                        }
                        case buildProperties: {
                            if (this.buildProperties == null) {
                                this.buildProperties = Lists.newArrayList();
                            }
                            this.buildProperties.add(row);
                            break;
                        }
                        case buildPromotions: {
                            if (this.buildPromotions == null) {
                                this.buildPromotions = Lists.newArrayList();
                            }
                            this.buildPromotions.add(row);
                            break;
                        }
                        case releaseBundles: {
                            if (this.releaseBundles == null) {
                                this.releaseBundles = Lists.newArrayList();
                            }
                            this.releaseBundles.add(row);
                            break;
                        }
                        case releaseBundleFiles: {
                            if (this.releaseBundleFiles == null) {
                                this.releaseBundleFiles = Lists.newArrayList();
                            }
                            this.releaseBundleFiles.add(row);
                        }
                    }
                }
            }
            return this;
        }

        public AqlDomainEnum getDomain() {
            return this.domain;
        }
    }
}

