/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.artifactory.aql.model.AqlItemTypeEnum;
import org.artifactory.aql.result.rows.AqlBaseFullRowImpl;
import org.artifactory.aql.result.rows.AqlItem;
import org.artifactory.aql.util.AqlUtils;
import org.artifactory.checksum.ChecksumInfo;
import org.artifactory.checksum.ChecksumType;
import org.artifactory.factory.InfoFactoryHolder;
import org.artifactory.fs.FileInfo;
import org.artifactory.fs.FolderInfo;
import org.artifactory.fs.ItemInfo;
import org.artifactory.fs.MutableFileInfo;
import org.artifactory.fs.MutableFolderInfo;
import org.artifactory.repo.RepoPath;

public abstract class AqlConverts {
    public static final Function<AqlItem, FolderInfo> toFolderInfo = aqlItem -> {
        RepoPath repoPath = AqlUtils.fromAql((AqlBaseFullRowImpl)aqlItem);
        MutableFolderInfo folderInfo = InfoFactoryHolder.get().createFolderInfo(repoPath);
        folderInfo.setCreated(aqlItem.getCreated().getTime());
        folderInfo.setLastUpdated(aqlItem.getUpdated().getTime());
        folderInfo.setCreatedBy(aqlItem.getCreatedBy());
        Date modified = aqlItem.getModified();
        if (modified != null) {
            folderInfo.setLastModified(modified.getTime());
        }
        folderInfo.setModifiedBy(aqlItem.getModifiedBy());
        return folderInfo;
    };
    public static final Function<AqlItem, FileInfo> toFileInfo = aqlItem -> {
        RepoPath repoPath = AqlUtils.fromAql((AqlBaseFullRowImpl)aqlItem);
        Long nodeId = aqlItem.getNodeId();
        MutableFileInfo fileInfo = nodeId != null ? InfoFactoryHolder.get().createFileInfo(repoPath, nodeId.longValue()) : InfoFactoryHolder.get().createFileInfo(repoPath);
        fileInfo.setSize(aqlItem.getSize());
        fileInfo.setCreated(aqlItem.getCreated().getTime());
        fileInfo.setLastUpdated(aqlItem.getUpdated().getTime());
        fileInfo.setCreatedBy(aqlItem.getCreatedBy());
        Date modified = aqlItem.getModified();
        if (modified != null) {
            fileInfo.setLastModified(modified.getTime());
        }
        fileInfo.setModifiedBy(aqlItem.getModifiedBy());
        HashSet checksums = Sets.newHashSet();
        checksums.add(new ChecksumInfo(ChecksumType.md5, aqlItem.getOriginalMd5(), aqlItem.getActualMd5()));
        checksums.add(new ChecksumInfo(ChecksumType.sha1, aqlItem.getOriginalSha1(), aqlItem.getActualSha1()));
        checksums.add(new ChecksumInfo(ChecksumType.sha256, "NO_ORIG", aqlItem.getSha2()));
        fileInfo.setChecksums((Set)checksums);
        return fileInfo;
    };
    public static final Function<AqlItem, String> toItemName = AqlItem::getName;
    public static final Function<AqlItem, FileInfo> toMinimalFileInfo = aqlItem -> {
        RepoPath repoPath = AqlUtils.fromAql((AqlBaseFullRowImpl)aqlItem);
        return InfoFactoryHolder.get().createFileInfo(repoPath);
    };
    public static final Function<AqlItem, ItemInfo> toItemInfo = aqlItem -> {
        if (AqlItemTypeEnum.folder == aqlItem.getType()) {
            return (ItemInfo)toFolderInfo.apply((AqlItem)aqlItem);
        }
        return (ItemInfo)toFileInfo.apply((AqlItem)aqlItem);
    };
    public static final Function<AqlItem, RepoPath> toRepoPath = aqlItem -> AqlUtils.fromAql((AqlBaseFullRowImpl)aqlItem);
}

