/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.distribution.bundle.models;

import java.util.List;
import org.artifactory.api.rest.distribution.bundle.models.BundleVersion;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class BundleVersionUtils {
    public static void sort(List<BundleVersion> bundleVersions) {
        bundleVersions.sort((v1, v2) -> {
            DateTime createdDate1 = BundleVersionUtils.getCreatedDate(v1);
            DateTime createdDate2 = BundleVersionUtils.getCreatedDate(v2);
            int res = createdDate2.compareTo((ReadableInstant)createdDate1);
            if (res != 0) {
                return res;
            }
            return v2.getVersion().compareTo(v1.getVersion());
        });
    }

    private static DateTime getCreatedDate(BundleVersion version) {
        return ISODateTimeFormat.dateTimeParser().withZoneUTC().parseDateTime(version.getCreated());
    }
}

