/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.repo.storage;

import java.io.Serializable;
import javax.annotation.Nonnull;
import lombok.Generated;

public class RepoStorageSummaryInfo
implements Serializable {
    private String repoKey;
    private RepositoryType repoType;
    private long foldersCount;
    private long filesCount;
    private long usedSpace;
    private String type;

    public RepoStorageSummaryInfo(@Nonnull String repoKey, RepositoryType repoType, long foldersCount, long filesCount, long usedSpace, String type) {
        this.repoKey = repoKey;
        this.repoType = repoType;
        this.filesCount = filesCount;
        this.foldersCount = foldersCount;
        this.usedSpace = usedSpace;
        this.type = type;
    }

    public String getRepoKey() {
        return this.repoKey;
    }

    public RepositoryType getRepoType() {
        return this.repoType;
    }

    public long getFoldersCount() {
        return this.foldersCount;
    }

    public long getFilesCount() {
        return this.filesCount;
    }

    public long getUsedSpace() {
        return this.usedSpace;
    }

    public long getItemsCount() {
        return this.getFoldersCount() + this.getFilesCount();
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepoStorageSummaryInfo that = (RepoStorageSummaryInfo)o;
        return this.repoKey.equals(that.repoKey);
    }

    public int hashCode() {
        return this.repoKey.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RepoStorageSummaryInfo{");
        sb.append("repoKey='").append(this.repoKey).append('\'');
        sb.append(", repoType=").append((Object)this.repoType);
        sb.append(", filesCount=").append(this.filesCount);
        sb.append(", foldersCount=").append(this.foldersCount);
        sb.append(", usedSpace=").append(this.usedSpace);
        sb.append('}');
        return sb.toString();
    }

    @Generated
    public RepoStorageSummaryInfo() {
    }

    public static enum RepositoryType {
        LOCAL,
        CACHE,
        REMOTE,
        VIRTUAL,
        DISTRIBUTION,
        BROKEN,
        NA;

    }
}

