/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.repo;

import java.util.List;
import org.artifactory.api.repo.BaseBrowsableItem;
import org.artifactory.fs.FileInfo;
import org.artifactory.fs.MutableItemInfo;
import org.artifactory.repo.RepoPath;

public class VirtualBrowsableItem
extends BaseBrowsableItem {
    private static final long serialVersionUID = 1L;
    private RepoPath repoPath;
    private List<String> repoKeys;

    public VirtualBrowsableItem(String name, boolean folder, long created, long lastModified, long size, RepoPath repoPath, List<String> repoKeys) {
        super(name, folder, created, lastModified, size);
        this.repoPath = repoPath;
        this.repoKeys = repoKeys;
    }

    public static <T extends MutableItemInfo> VirtualBrowsableItem getItem(RepoPath repoPath, T itemInfo, List<String> repoKeys) {
        if (itemInfo.isFolder()) {
            return new VirtualBrowsableItem(itemInfo.getName(), true, itemInfo.getCreated(), itemInfo.getLastModified(), 0L, repoPath, repoKeys);
        }
        return new VirtualBrowsableItem(itemInfo.getName(), false, itemInfo.getCreated(), itemInfo.getLastModified(), ((FileInfo)itemInfo).getSize(), repoPath, repoKeys);
    }

    @Override
    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    @Override
    public String getRepoKey() {
        return this.repoPath.getRepoKey();
    }

    public void addRepoKey(String repoKey) {
        this.repoKeys.add(repoKey);
    }

    @Override
    public String getRelativePath() {
        return this.repoPath.getPath();
    }

    public List<String> getRepoKeys() {
        return this.repoKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualBrowsableItem item = (VirtualBrowsableItem)o;
        return this.repoPath.getPath().equals(item.getRelativePath());
    }

    public int hashCode() {
        return this.repoPath.getPath().hashCode();
    }

    @Override
    public int compareTo(BaseBrowsableItem o) {
        if (o.name.equals("..") && this.name.equals("..") && this.isFolder() && o.isFolder()) {
            return 0;
        }
        if (this.name.equals("..") || this.isFolder() && !o.isFolder()) {
            return -1;
        }
        if (o.name.equals("..") || !this.isFolder() && o.isFolder()) {
            return 1;
        }
        return this.repoPath.getPath().compareTo(o.getRelativePath());
    }
}

