/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module.regex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.artifactory.api.module.regex.NamedMatchResult;
import org.artifactory.api.module.regex.NamedPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedMatcher
implements NamedMatchResult {
    private static final Logger log = LoggerFactory.getLogger(NamedMatcher.class);
    private Matcher matcher;
    private NamedPattern parentPattern;

    NamedMatcher() {
    }

    NamedMatcher(NamedPattern parentPattern, MatchResult matcher) {
        this.parentPattern = parentPattern;
        this.matcher = (Matcher)matcher;
    }

    NamedMatcher(NamedPattern parentPattern, CharSequence input) {
        this.parentPattern = parentPattern;
        this.matcher = parentPattern.pattern().matcher(input);
    }

    public Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public NamedPattern namedPattern() {
        return this.parentPattern;
    }

    public NamedMatcher usePattern(NamedPattern newPattern) {
        this.parentPattern = newPattern;
        this.matcher.usePattern(newPattern.pattern());
        return this;
    }

    public NamedMatcher reset() {
        this.matcher.reset();
        return this;
    }

    public NamedMatcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    public boolean regexpMatches() {
        return this.matcher.matches();
    }

    public boolean matches() {
        if (!this.matcher.matches()) {
            return false;
        }
        if (this.groupCount() != this.parentPattern.groupNames().size()) {
            log.error("Regular expression '" + this.parentPattern.namedPattern() + "' uses unnamed capturing group!");
            return false;
        }
        return this.matcher.matches();
    }

    public NamedMatchResult toMatchResult() {
        return new NamedMatcher(this.parentPattern, this.matcher.toMatchResult());
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) {
        return this.matcher.find(start);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public NamedMatcher appendReplacement(StringBuffer sb, String replacement) {
        this.matcher.appendReplacement(sb, replacement);
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public List<String> orderedGroups() {
        ArrayList groups = Lists.newArrayList();
        for (int i = 1; i <= this.groupCount(); ++i) {
            groups.add(this.group(i));
        }
        return groups;
    }

    @Override
    public String group(String groupName) {
        return this.group(this.groupIndex(groupName));
    }

    @Override
    public Map<String, String> namedGroups() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (!this.matches()) {
            log.error("Pattern did not match! Cannot extract named groups!");
            return result;
        }
        for (int i = 1; i <= this.groupCount(); ++i) {
            String groupName = this.parentPattern.groupNames().get(i - 1);
            String groupValue = this.matcher.group(i);
            result.put(groupName, groupValue);
        }
        return result;
    }

    private int groupIndex(String groupName) {
        return this.parentPattern.groupNames().indexOf(groupName) + 1;
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int start(String groupName) {
        return this.start(this.groupIndex(groupName));
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public int end(String groupName) {
        return this.end(this.groupIndex(groupName));
    }

    public NamedMatcher region(int start, int end) {
        this.matcher.region(start, end);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceFirst(String replacement) {
        return this.matcher.replaceFirst(replacement);
    }

    public NamedMatcher useAnchoringBounds(boolean b) {
        this.matcher.useAnchoringBounds(b);
        return this;
    }

    public NamedMatcher useTransparentBounds(boolean b) {
        this.matcher.useTransparentBounds(b);
        return this;
    }

    public boolean equals(Object obj) {
        return this.matcher.equals(obj);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }
}

