/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.rule;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.bintray.distribution.rule.DistributionRuleToken;
import org.artifactory.md.Properties;
import org.artifactory.repo.RepoPath;

public class DistributionRuleLayoutToken
extends DistributionRuleToken {
    public DistributionRuleLayoutToken(String token) {
        this.token = token;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void populateValue(RepoPath path, Properties pathProperties) throws Exception {
        this.value = pathProperties.getFirst(this.token);
        if (StringUtils.isBlank((String)this.value)) {
            throw new Exception("No value was resolved for layout token " + this.token + " on artifact " + path.toPath());
        }
    }

    @Override
    public void populateValue(RepoPath path, Map<String, List<String>> pathProperties) throws Exception {
        List<String> values = pathProperties.get(this.token);
        if (CollectionUtils.isEmpty(values)) {
            throw new Exception("No value was resolved for layout token " + this.token + " on artifact " + path.toPath());
        }
        this.value = values.get(0);
        if (StringUtils.isBlank((String)this.value)) {
            throw new Exception("No value was resolved for layout token " + this.token + " on artifact " + path.toPath());
        }
    }
}

