/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.resolver;

import java.util.regex.Pattern;

public enum DistributionRuleFilterType {
    repo("repo"),
    path("path");

    public static final Pattern GENERAL_CAP_GROUP_PATTERN;
    private static final Pattern NUMBER_PATTERN;
    private final String qualifier;
    private final Pattern capGroupPattern;

    private DistributionRuleFilterType(String qualifier) {
        this.qualifier = qualifier;
        this.capGroupPattern = DistributionRuleFilterType.createCapGroupPattern(qualifier);
    }

    private static Pattern createCapGroupPattern(String qualifier) {
        return Pattern.compile("(\\$\\{" + qualifier + ":[a-zA-Z0-9]+\\})");
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Pattern getCaptureGroupPattern() {
        return this.capGroupPattern;
    }

    public int getGroupNumber(String group) throws NumberFormatException {
        return Integer.parseInt(this.getGroupId(group));
    }

    public String getGroupName(String group) {
        return this.getGroupId(group);
    }

    public boolean isNamedGroup(String group) {
        return !NUMBER_PATTERN.matcher(this.getGroupId(group)).matches();
    }

    private String getGroupId(String group) {
        int start = ("${" + this.qualifier + ":").length();
        return group.substring(start, group.length() - 1);
    }

    static {
        GENERAL_CAP_GROUP_PATTERN = DistributionRuleFilterType.createCapGroupPattern("[a-z]+");
        NUMBER_PATTERN = Pattern.compile("\\d+");
    }
}

