/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.reporting.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.jfrog.bintray.client.api.details.VersionDetails;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.artifactory.api.bintray.BintrayUploadInfo;

public class BintrayVersionModel {
    public String versionName;
    public Boolean created;
    public Multimap<String, String> attributes = HashMultimap.create();
    public Set<String> paths = Sets.newHashSet();

    public BintrayVersionModel() {
    }

    public BintrayVersionModel(BintrayUploadInfo uploadInfo) {
        VersionDetails versionDetails = uploadInfo.getVersionDetails();
        this.versionName = versionDetails.getName();
        if (versionDetails.getAttributes() != null) {
            versionDetails.getAttributes().forEach(attribute -> this.attributes.putAll((Object)attribute.getName(), (Iterable)attribute.getValues()));
        }
    }

    public void merge(BintrayVersionModel version) {
        this.attributes.putAll(version.attributes);
        this.paths.addAll(version.paths);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public Boolean getCreated() {
        return this.created;
    }

    public Map<String, Collection<String>> getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.asMap();
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BintrayVersionModel)) {
            return false;
        }
        BintrayVersionModel that = (BintrayVersionModel)o;
        return this.versionName != null ? this.versionName.equals(that.versionName) : that.versionName == null;
    }

    public int hashCode() {
        return this.versionName != null ? this.versionName.hashCode() : 0;
    }
}

