package org.artifactory.api.bintray.distribution.resolver;

import org.apache.commons.lang3.builder.*;
import java.util.function.BiFunction;
import java.util.*;
import java.util.stream.*;
import org.jfrog.common.config.diff.DiffUtils;


import org.jfrog.common.config.diff.DiffFunctions;

public class DiffFunctionsImpl implements DiffFunctions{
  Map<String, BiFunction<Object, Object, DiffResult>> diffFunctions = new HashMap<>();
  @Override
  public <T> DiffResult diffFor(Class<T> c, T object, T other) {
    return diffFunctions.get(c.getSimpleName()).apply(object, other);
  }

  @Override
  public <T> boolean containsClass(Class<T> c) {
    return diffFunctions.containsKey(c.getSimpleName());
  }

  private DiffResult distributionCoordinatesResolver(DistributionCoordinatesResolver object, DistributionCoordinatesResolver other) {
    DiffBuilder db = new DiffBuilder(object, other, ToStringStyle.DEFAULT_STYLE, false);
    db.append("path", object.getPath(), other.getPath());
    db.append("pkg", object.getPkg(), other.getPkg());
    db.append("repo", object.getRepo(), other.getRepo());
    db.append("version", object.getVersion(), other.getVersion());
    return db.build();
  }
  public DiffFunctionsImpl() {
    diffFunctions.put("DistributionCoordinatesResolver", (object, other) -> distributionCoordinatesResolver((DistributionCoordinatesResolver)object, (DistributionCoordinatesResolver)other));
  }

}
