/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows.populate;

import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.artifactory.aql.model.AqlRepoProvider;
import org.artifactory.aql.model.DomainSensitiveField;

public class ResultPopulationContext {
    private final ResultSet resultSet;
    private final List<DomainSensitiveField> resultFields;
    private final AqlRepoProvider repoProvider;
    private final Map<String, List<String>> virtualRepoKeysContainingRepoCache = Maps.newHashMap();

    public ResultPopulationContext(ResultSet resultSet, List<DomainSensitiveField> resultFields, AqlRepoProvider repoProvider) {
        this.resultFields = resultFields;
        this.resultSet = resultSet;
        this.repoProvider = repoProvider;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public List<DomainSensitiveField> getResultFields() {
        return Collections.unmodifiableList(this.resultFields);
    }

    public AqlRepoProvider getRepoProvider() {
        return this.repoProvider;
    }

    public List<String> getVirtualRepoKeysContainingRepo(String repoKey) {
        List<String> virtualRepoKeys = this.virtualRepoKeysContainingRepoCache.get(repoKey);
        if (virtualRepoKeys == null) {
            virtualRepoKeys = this.repoProvider.getVirtualRepoKeysContainingRepo(repoKey);
            this.virtualRepoKeysContainingRepoCache.put(repoKey, virtualRepoKeys);
        }
        return virtualRepoKeys;
    }
}

