/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.artifactory.aql.AqlException;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.AqlRestResult;
import org.artifactory.aql.result.rows.RowResult;

public class InflatableRow
implements RowResult {
    private Map<DomainSensitiveField, Object> map = Maps.newHashMap();

    @Override
    public void put(DomainSensitiveField field, Object value) {
        this.map.put(field, value);
    }

    @Override
    public Object get(DomainSensitiveField field) {
        return this.map.get(field);
    }

    public Map<String, AqlRestResult.Row> inflate() {
        HashMap result = Maps.newHashMap();
        AqlRestResult.Row prev = null;
        for (DomainSensitiveField field : this.map.keySet()) {
            Map<Object, Object> current = result;
            List<AqlDomainEnum> subDomains = field.getSubDomains();
            for (AqlDomainEnum subDomain : subDomains) {
                AqlRestResult.Row row;
                String id = this.resolveId(subDomain);
                if (current == null) {
                    current = Maps.newHashMap();
                    prev.subDomains = current;
                }
                if ((row = (AqlRestResult.Row)current.get(id)) == null) {
                    row = new AqlRestResult.Row(subDomain);
                    current.put(id, row);
                    this.fillRelevantFields(row, subDomain);
                }
                prev = row;
                current = row.subDomains;
            }
        }
        this.clean((AqlRestResult.Row)result.values().iterator().next());
        return result;
    }

    private boolean clean(AqlRestResult.Row next) {
        if (next.subDomains != null) {
            Iterator<AqlRestResult.Row> iterator = next.subDomains.values().iterator();
            while (iterator.hasNext()) {
                AqlRestResult.Row row = iterator.next();
                if (!this.clean(row)) continue;
                iterator.remove();
            }
        }
        try {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = next.getClass().getFields()) {
                if (declaredField.getName().equals("subDomains") || declaredField.getName().equals("domain")) continue;
                declaredField.setAccessible(true);
                Object value = declaredField.get(next);
                if (value == null || "archiveId".equals(declaredField.getName()) || AqlPhysicalFieldEnum.valueOf(declaredField.getName()).isId()) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            throw new AqlException("Failed to map result fields", e);
        }
        return next.subDomains == null || next.subDomains.size() == 0;
    }

    private boolean fillRelevantFields(AqlRestResult.Row row, AqlDomainEnum subDomain) {
        boolean containsData = false;
        for (DomainSensitiveField field : this.map.keySet()) {
            Object value = this.map.get(field);
            if (field.getField().getDomain() != subDomain) continue;
            if (value != null && !field.getField().isId()) {
                containsData = true;
            }
            row.put(field.getField().getName(), value);
        }
        return containsData;
    }

    private String resolveId(AqlDomainEnum domain) {
        StringBuilder builder = new StringBuilder();
        for (DomainSensitiveField domainSensitiveField : this.map.keySet()) {
            AqlDomainEnum fieldDomain = domainSensitiveField.getField().getDomain();
            if (fieldDomain != domain) continue;
            String elementKey = domainSensitiveField.getField().getName();
            Object value = this.map.get(domainSensitiveField);
            builder.append("((key:").append(elementKey).append(")(value:").append(this.toString(value)).append("))");
        }
        return builder.toString();
    }

    private String toString(Object value) {
        if (value != null && value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return String.valueOf(value);
    }
}

