/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.search.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.artifactory.api.search.stats.StatsSearchResult;
import org.jfrog.client.util.PathUtils;
import org.joda.time.format.ISODateTimeFormat;

public class LastDownloadRestResult {
    public List<DownloadedEntry> results = new ArrayList<DownloadedEntry>();

    public static String toIsoDateString(long time) {
        return ISODateTimeFormat.dateTime().print(time);
    }

    public String toString() {
        return PathUtils.collectionToDelimitedString((Iterable)this.results.stream().map(DownloadedEntry::toString).collect(Collectors.toList()));
    }

    public static class DownloadedEntry {
        public String uri;
        public long downloadCount;
        public String lastDownloaded;
        public long remoteDownloadCount;
        public String remoteLastDownloaded;

        public DownloadedEntry() {
        }

        public DownloadedEntry(String uri, StatsSearchResult result) {
            this.uri = uri;
            this.downloadCount = result.getDownloadCount();
            this.lastDownloaded = LastDownloadRestResult.toIsoDateString(result.getLastDownloaded());
            this.remoteDownloadCount = result.getRemoteDownloadCount();
            this.remoteLastDownloaded = LastDownloadRestResult.toIsoDateString(result.getRemoteLastDownloaded());
        }

        public String toString() {
            return "DownloadedEntry{uri='" + this.uri + '\'' + ", downloadCount=" + this.downloadCount + ", lastDownloaded='" + this.lastDownloaded + '\'' + ", remoteDownloadCount=" + this.remoteDownloadCount + ", remoteLastDownloaded='" + this.remoteLastDownloaded + '\'' + '}';
        }
    }
}

