/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.restmodel;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String jsonToString(Object model) {
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.disableDefaultTyping();
        String jasonString = null;
        try {
            jasonString = mapper.writeValueAsString(model);
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return jasonString;
    }

    public static <T> T mapDataToModel(InputStream data, Class<T> valueType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object model = mapper.readValue(data, valueType);
        return (T)model;
    }
}

