/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.distribution.bundle.utils;

import com.google.common.base.Splitter;
import java.util.List;

public class BundleNameVersionResolver {
    private String bundleName;
    private String bundleVersion;

    public BundleNameVersionResolver(String transactionPath) {
        List<String> pathParts = this.getPathParts(transactionPath);
        if (pathParts.size() < 3) {
            throw new IllegalArgumentException("Invalid transaction path");
        }
        this.bundleName = pathParts.get(1);
        this.bundleVersion = pathParts.get(2);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    private List<String> getPathParts(String transactionPath) {
        return Splitter.on((String)"/").splitToList((CharSequence)transactionPath);
    }
}

