/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.distribution.bundle.models;

import com.google.common.base.Joiner;
import java.util.List;
import lombok.Generated;
import org.artifactory.api.rest.distribution.bundle.models.ArtifactProperty;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jfrog.common.ArgUtils;

public class FileSpec {
    @JsonProperty(value="source_path")
    String sourcePath;
    List<ArtifactProperty> props;
    @JsonProperty(value="target_artifactory_url")
    String targetArtifactoryUrl;
    @JsonProperty(value="target_path")
    String targetPath;
    @JsonProperty(value="release_bundle")
    boolean releaseBundle;
    @JsonIgnore
    String internalTmpPath;

    public void setInternalTmpPath(String transactionPath) {
        this.internalTmpPath = Joiner.on((String)"/").join((Object)transactionPath, (Object)this.targetPath, new Object[0]);
    }

    public String toString() {
        return "FileSpec{sourcePath='" + this.sourcePath + '\'' + ", props=" + this.props + ", targetArtifactoryUrl='" + this.targetArtifactoryUrl + '\'' + ", targetPath='" + this.targetPath + '\'' + ", releaseBundle=" + this.releaseBundle + ", internalTmpPath='" + this.internalTmpPath + '\'' + '}';
    }

    public void validate() {
        this.sourcePath = ArgUtils.requireNonBlank((String)this.sourcePath, (String)"source_path must not be blank");
        this.targetPath = ArgUtils.requireNonBlank((String)this.targetPath, (String)"target_path must not be blank");
        this.targetArtifactoryUrl = ArgUtils.requireNonBlank((String)this.targetArtifactoryUrl, (String)"target_artifactory_url must not be blank");
    }

    @Generated
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Generated
    public List<ArtifactProperty> getProps() {
        return this.props;
    }

    @Generated
    public String getTargetArtifactoryUrl() {
        return this.targetArtifactoryUrl;
    }

    @Generated
    public String getTargetPath() {
        return this.targetPath;
    }

    @Generated
    public boolean isReleaseBundle() {
        return this.releaseBundle;
    }

    @Generated
    public String getInternalTmpPath() {
        return this.internalTmpPath;
    }

    @Generated
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Generated
    public void setProps(List<ArtifactProperty> props) {
        this.props = props;
    }

    @Generated
    public void setTargetArtifactoryUrl(String targetArtifactoryUrl) {
        this.targetArtifactoryUrl = targetArtifactoryUrl;
    }

    @Generated
    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    @Generated
    public void setReleaseBundle(boolean releaseBundle) {
        this.releaseBundle = releaseBundle;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSpec)) {
            return false;
        }
        FileSpec other = (FileSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sourcePath = this.getSourcePath();
        String other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
            return false;
        }
        List<ArtifactProperty> this$props = this.getProps();
        List<ArtifactProperty> other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        String this$targetArtifactoryUrl = this.getTargetArtifactoryUrl();
        String other$targetArtifactoryUrl = other.getTargetArtifactoryUrl();
        if (this$targetArtifactoryUrl == null ? other$targetArtifactoryUrl != null : !this$targetArtifactoryUrl.equals(other$targetArtifactoryUrl)) {
            return false;
        }
        String this$targetPath = this.getTargetPath();
        String other$targetPath = other.getTargetPath();
        if (this$targetPath == null ? other$targetPath != null : !this$targetPath.equals(other$targetPath)) {
            return false;
        }
        if (this.isReleaseBundle() != other.isReleaseBundle()) {
            return false;
        }
        String this$internalTmpPath = this.getInternalTmpPath();
        String other$internalTmpPath = other.getInternalTmpPath();
        return !(this$internalTmpPath == null ? other$internalTmpPath != null : !this$internalTmpPath.equals(other$internalTmpPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
        List<ArtifactProperty> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        String $targetArtifactoryUrl = this.getTargetArtifactoryUrl();
        result = result * 59 + ($targetArtifactoryUrl == null ? 43 : $targetArtifactoryUrl.hashCode());
        String $targetPath = this.getTargetPath();
        result = result * 59 + ($targetPath == null ? 43 : $targetPath.hashCode());
        result = result * 59 + (this.isReleaseBundle() ? 79 : 97);
        String $internalTmpPath = this.getInternalTmpPath();
        result = result * 59 + ($internalTmpPath == null ? 43 : $internalTmpPath.hashCode());
        return result;
    }

    @Generated
    public FileSpec() {
    }
}

