/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import lombok.Generated;
import org.artifactory.common.ArtifactoryHome;
import org.artifactory.common.crypto.CryptoHelper;
import org.artifactory.descriptor.mail.MailServerDescriptor;
import org.codehaus.jackson.annotate.JsonProperty;

public class MailServerModel {
    private boolean enabled;
    private String host;
    private int port;
    private String username;
    private String password;
    private String from;
    @JsonProperty(value="subject_prefix")
    private String subjectPrefix;
    @JsonProperty(value="artifactory_url")
    private String artifactoryUrl;
    private boolean tls;
    private boolean ssl;

    public MailServerModel(MailServerDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.enabled = descriptor.isEnabled();
        this.host = descriptor.getHost();
        this.port = descriptor.getPort();
        this.username = descriptor.getUsername();
        this.password = descriptor.getPassword();
        this.from = descriptor.getFrom();
        this.subjectPrefix = descriptor.getSubjectPrefix();
        this.artifactoryUrl = descriptor.getArtifactoryUrl();
        this.tls = descriptor.isTls();
        this.ssl = descriptor.isSsl();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return CryptoHelper.decryptIfNeeded((ArtifactoryHome)ArtifactoryHome.get(), (String)this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubjectPrefix() {
        return this.subjectPrefix;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    @Generated
    public MailServerModel() {
    }
}

