/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.callhome;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.callhome.FeatureGroup;
import org.artifactory.api.rest.subscription.Subscription;
import org.codehaus.jackson.annotate.JsonProperty;

public class CallHomeRequest {
    public String product = "JFrog-Artifactory";
    public String repository = "artifactory";
    @JsonProperty(value="package")
    public String packageName = "jfrog-artifactory-generic";
    public String version;
    @JsonProperty(value="artifactory_license_type")
    public String licenseType;
    @JsonProperty(value="artifactory_license_oem")
    public String licenseOEM;
    @JsonProperty(value="artifactory_license_expiration")
    public String licenseExpiration;
    @JsonProperty(value="db_type")
    public String dbType;
    @JsonProperty(value="db_version")
    public String dbVersion;
    public String dist = "unknown";
    public String setup;
    @JsonProperty(value="nunmber_of_nodes")
    public Integer numberOfNodes;
    @JsonProperty(value="account_name")
    public String accountName;
    public Environment environment = new Environment();
    public Subscription subscription;
    @JsonProperty(value="feature_groups")
    private List<FeatureGroup> featureGroups;

    public void addCallHomeFeature(FeatureGroup callHomeFeature) {
        if (this.featureGroups == null) {
            this.featureGroups = Lists.newLinkedList();
        }
        if (callHomeFeature != null) {
            this.featureGroups.add(callHomeFeature);
        }
    }

    public void setDist(String artdist) {
        if (StringUtils.isBlank((String)artdist)) {
            return;
        }
        this.dist = artdist;
        String repoSuffix = StringUtils.equals((String)this.licenseType, (String)"oss") ? "" : "-pro";
        String pkgSuffix = StringUtils.equals((String)this.licenseType, (String)"oss") ? "-oss" : "-pro";
        switch (artdist) {
            case "docker": {
                this.repository = "registry";
                this.packageName = "artifactory:artifactory" + pkgSuffix;
                break;
            }
            case "zip": {
                this.repository = "artifactory" + repoSuffix;
                this.packageName = "jfrog-artifactory" + pkgSuffix + "-zip";
                break;
            }
            case "rpm": {
                this.repository = "artifactory" + repoSuffix + "-rpms";
                this.packageName = "jfrog-artifactory" + pkgSuffix + "-rpm";
                break;
            }
            case "deb": {
                this.repository = "artifactory" + repoSuffix + "-debs";
                this.packageName = "jfrog-artifactory" + pkgSuffix + "-deb";
            }
        }
    }

    public static class Environment {
        @JsonProperty(value="runtime_id")
        public String hostId;
        @JsonProperty(value="service_id")
        public String serviceId;
        @JsonProperty(value="user_id")
        public String licenseHash;
        public Attributes attributes = new Attributes();

        public static class Attributes {
            @JsonProperty(value="os_name")
            public String osName;
            @JsonProperty(value="os_arch")
            public String osArch;
            @JsonProperty(value="java_version")
            public String javaVersion;
        }
    }
}

