/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.build;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.build.BuildProps;
import org.artifactory.api.build.GeneralBuild;
import org.artifactory.api.build.ImportableExportableBuild;
import org.artifactory.api.build.ModuleArtifact;
import org.artifactory.api.build.ModuleDependency;
import org.artifactory.api.build.PublishedModule;
import org.artifactory.api.build.model.BuildGeneralInfo;
import org.artifactory.api.build.model.diff.BuildParams;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.api.config.ImportableExportable;
import org.artifactory.api.rest.artifact.PromotionResult;
import org.artifactory.api.rest.build.ContinueBuildFilter;
import org.artifactory.build.BuildId;
import org.artifactory.build.BuildRun;
import org.artifactory.fs.FileInfo;
import org.artifactory.sapi.common.ExportSettings;
import org.artifactory.sapi.common.ImportSettings;
import org.artifactory.sapi.common.Lock;
import org.artifactory.ui.rest.service.builds.search.BuildsSearchFilter;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.release.PromotionStatus;

public interface BuildService
extends ImportableExportable {
    public static final String UNSPECIFIED_SCOPE = "unspecified";
    public static final String LATEST_BUILD = "LATEST";
    public static final String LAST_RELEASED_BUILD = "LAST_RELEASE";
    public static final String BUILDS_EXPORT_DIR = "builds";

    public boolean isBuildInfoReady();

    public String getBuildInfoRepoKey();

    @Lock
    public void addBuild(Build var1);

    public void updateBuild(@Nonnull Build var1);

    public String getBuildAsJson(BuildRun var1);

    public void deleteAllBuildsByName(String var1, boolean var2, BasicStatusHolder var3);

    public void deleteAllBuildsByName(List<String> var1, boolean var2, BasicStatusHolder var3);

    public void deleteBuildNumberByRetention(BuildRun var1, boolean var2, boolean var3, BasicStatusHolder var4);

    @Lock
    public void deleteBuild(BuildRun var1, boolean var2, BasicStatusHolder var3);

    public void removeBuildArtifacts(BuildRun var1, BasicStatusHolder var2);

    public Build getBuild(BuildRun var1);

    public ImportableExportableBuild getExportableBuild(BuildRun var1);

    public List<String> getBuildNames();

    @Nullable
    public Build getLatestBuildByNameAndNumber(String var1, String var2);

    public SortedSet<BuildRun> searchBuildsByName(String var1);

    public Set<BuildRun> searchBuildsByNameAndNumber(String var1, String var2);

    public Set<BuildRun> searchBuildsByNameAndNumberInternal(String var1, String var2);

    public BuildRun getBuildRun(String var1, String var2, String var3);

    @Override
    public void exportTo(ExportSettings var1);

    @Override
    public void importFrom(ImportSettings var1);

    public PromotionResult promoteBuild(BuildRun var1, Promotion var2);

    public void renameBuilds(String var1, String var2);

    @Lock
    public void addPromotionStatus(Build var1, PromotionStatus var2);

    @Nullable
    public List<PublishedModule> getPublishedModules(String var1, String var2, String var3);

    public List<ModuleArtifact> getModuleArtifact(String var1, String var2, String var3, String var4);

    public List<ModuleDependency> getModuleDependency(String var1, String var2, String var3, String var4);

    public List<ModuleArtifact> getModuleArtifactsForDiffWithPaging(BuildParams var1);

    public List<ModuleDependency> getModuleDependencyForDiffWithPaging(BuildParams var1);

    public List<GeneralBuild> getPrevBuildsList(String var1, String var2);

    public List<BuildProps> getBuildPropsData(BuildParams var1);

    public List<BuildId> getLatestBuildIDsPaging(ContinueBuildFilter var1);

    public List<BuildId> getBuildIDsByName(String var1, String var2, String var3, long var4, String var6, String var7);

    public List<GeneralBuild> getBuildVersions(BuildsSearchFilter var1);

    public List<GeneralBuild> getBuildForName(String var1, ContinueBuildFilter var2) throws SQLException;

    public List<FileInfo> collectBuildArtifacts(Build var1, @Nullable List<String> var2, @Nullable List<String> var3, @Nullable BasicStatusHolder var4);

    public void assertBasicReadPermissions(String var1, String var2, String var3);

    public void assertReadPermissions(String var1, String var2, String var3);

    public void assertDeletePermissions(String var1, String var2, String var3);

    public void assertUploadPermissions(String var1, String var2, String var3);

    public BuildGeneralInfo getBuildGeneralInfo(String var1, String var2, String var3);
}

