/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows.populate;

import com.google.common.collect.Iterators;
import java.sql.SQLException;
import java.util.Iterator;
import org.artifactory.aql.model.AqlFieldEnumSwitch;
import org.artifactory.aql.model.AqlLogicalFieldEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.rows.populate.FieldResultPopulator;
import org.artifactory.aql.result.rows.populate.LogicalFieldResultPopulators;
import org.artifactory.aql.result.rows.populate.RowPopulationContext;

public final class RowPopulation {
    private static final AqlFieldEnumSwitch<Boolean> physicalFields = new AqlFieldEnumSwitch<Boolean>(){

        @Override
        public Boolean caseOf(AqlLogicalFieldEnum fieldEnum) {
            return false;
        }

        @Override
        public Boolean caseOf(AqlPhysicalFieldEnum fieldEnum) {
            return true;
        }
    };
    private static final AqlFieldEnumSwitch<Boolean> logicalFields = new AqlFieldEnumSwitch<Boolean>(){

        @Override
        public Boolean caseOf(AqlLogicalFieldEnum fieldEnum) {
            return true;
        }

        @Override
        public Boolean caseOf(AqlPhysicalFieldEnum fieldEnum) {
            return false;
        }
    };

    private RowPopulation() {
    }

    public static void populatePhysicalFields(RowPopulationContext populationContext, FieldResultPopulator fieldPopulator) throws SQLException {
        Iterator<DomainSensitiveField> resultFields = RowPopulation.getResultFields(populationContext, physicalFields);
        while (resultFields.hasNext()) {
            DomainSensitiveField field = resultFields.next();
            fieldPopulator.populate(populationContext, field);
        }
    }

    public static void populateLogicalFields(RowPopulationContext populationContext) throws SQLException {
        Iterator<DomainSensitiveField> resultFields = RowPopulation.getResultFields(populationContext, logicalFields);
        while (resultFields.hasNext()) {
            DomainSensitiveField field = resultFields.next();
            FieldResultPopulator populator = LogicalFieldResultPopulators.getPopulator(field);
            populator.populate(populationContext, field);
        }
    }

    private static Iterator<DomainSensitiveField> getResultFields(RowPopulationContext populationContext, AqlFieldEnumSwitch<Boolean> fieldSwitch) {
        return Iterators.filter(populationContext.getResultFields().iterator(), field -> (Boolean)field.getField().doSwitch(fieldSwitch));
    }
}

